/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.pagememory.persistence.checkpoint;

import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;
import java.util.concurrent.locks.Lock;
import java.util.function.BooleanSupplier;
import org.apache.ignite.internal.components.LogSyncer;
import org.apache.ignite.internal.components.LongJvmPauseDetector;
import org.apache.ignite.internal.failure.FailureContext;
import org.apache.ignite.internal.failure.FailureManager;
import org.apache.ignite.internal.failure.FailureType;
import org.apache.ignite.internal.lang.IgniteBiTuple;
import org.apache.ignite.internal.lang.IgniteInternalCheckedException;
import org.apache.ignite.internal.lang.IgniteInternalException;
import org.apache.ignite.internal.lang.NodeStoppingException;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.pagememory.DataRegion;
import org.apache.ignite.internal.pagememory.configuration.CheckpointConfiguration;
import org.apache.ignite.internal.pagememory.persistence.GroupPartitionId;
import org.apache.ignite.internal.pagememory.persistence.PartitionDestructionLockManager;
import org.apache.ignite.internal.pagememory.persistence.PartitionMeta;
import org.apache.ignite.internal.pagememory.persistence.PartitionMetaManager;
import org.apache.ignite.internal.pagememory.persistence.PersistentPageMemory;
import org.apache.ignite.internal.pagememory.persistence.WriteSpeedFormatter;
import org.apache.ignite.internal.pagememory.persistence.checkpoint.Checkpoint;
import org.apache.ignite.internal.pagememory.persistence.checkpoint.CheckpointDirtyPages;
import org.apache.ignite.internal.pagememory.persistence.checkpoint.CheckpointMetricsTracker;
import org.apache.ignite.internal.pagememory.persistence.checkpoint.CheckpointPagesWriter;
import org.apache.ignite.internal.pagememory.persistence.checkpoint.CheckpointPagesWriterFactory;
import org.apache.ignite.internal.pagememory.persistence.checkpoint.CheckpointProgress;
import org.apache.ignite.internal.pagememory.persistence.checkpoint.CheckpointProgressImpl;
import org.apache.ignite.internal.pagememory.persistence.checkpoint.CheckpointState;
import org.apache.ignite.internal.pagememory.persistence.checkpoint.CheckpointWorkflow;
import org.apache.ignite.internal.pagememory.persistence.checkpoint.IgniteCheckpointThreadFactory;
import org.apache.ignite.internal.pagememory.persistence.compaction.Compactor;
import org.apache.ignite.internal.pagememory.persistence.store.DeltaFilePageStoreIo;
import org.apache.ignite.internal.pagememory.persistence.store.FilePageStore;
import org.apache.ignite.internal.pagememory.persistence.store.FilePageStoreManager;
import org.apache.ignite.internal.thread.IgniteThread;
import org.apache.ignite.internal.thread.ThreadOperation;
import org.apache.ignite.internal.util.FastTimestamps;
import org.apache.ignite.internal.util.IgniteConcurrentMultiPairQueue;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.util.worker.IgniteWorker;
import org.apache.ignite.internal.util.worker.WorkProgressDispatcher;
import org.jetbrains.annotations.Nullable;

public class Checkpointer
extends IgniteWorker {
    private static final String CHECKPOINT_STARTED_LOG_TEMPLATE = "Checkpoint started [checkpointId={}, beforeWriteLockTime={}ms, writeLockWait={}us, listenersExecuteTime={}us, writeLockHoldTime={}us, splitAndSortPagesDuration={}ms, {}pages={}, reason='{}']";
    private static final String CHECKPOINT_SKIPPED_LOG_TEMPLATE = "Skipping checkpoint (no pages were modified) [beforeWriteLockTime={}ms, writeLockWait={}us, listenersExecuteTime={}us, writeLockHoldTime={}us, reason='{}']";
    private static final String CHECKPOINT_FINISHED_LOG_TEMPLATE = "Checkpoint finished [checkpointId={}, pages={}, pagesWriteTime={}ms, fsyncTime={}ms, replicatorLogSyncTime={}ms, waitCompletePageReplacementTime={}ms, totalTime={}ms, avgWriteSpeed={}MB/s]";
    private static final IgniteLogger LOG = Loggers.forClass(Checkpointer.class);
    @Nullable
    private final LongJvmPauseDetector pauseDetector;
    private final int pageSize;
    private final CheckpointConfiguration checkpointConfig;
    private final CheckpointWorkflow checkpointWorkflow;
    private final CheckpointPagesWriterFactory checkpointPagesWriterFactory;
    @Nullable
    private final ThreadPoolExecutor checkpointWritePagesPool;
    private final PartitionMetaManager partitionMetaManager;
    private volatile CheckpointProgressImpl scheduledCheckpointProgress;
    @Nullable
    private volatile CheckpointProgressImpl currentCheckpointProgress;
    @Nullable
    private volatile CheckpointProgressImpl currentCheckpointProgressForThrottling;
    @Nullable
    private volatile CheckpointProgressImpl afterReleaseWriteLockCheckpointProgress;
    private volatile boolean shutdownNow;
    private long lastCheckpointTimestamp;
    private final FilePageStoreManager filePageStoreManager;
    private final Compactor compactor;
    private final FailureManager failureManager;
    private final LogSyncer logSyncer;
    private final PartitionDestructionLockManager partitionDestructionLockManager;

    Checkpointer(String igniteInstanceName, @Nullable LongJvmPauseDetector detector, FailureManager failureManager, CheckpointWorkflow checkpointWorkFlow, CheckpointPagesWriterFactory factory, FilePageStoreManager filePageStoreManager, PartitionMetaManager partitionMetaManager, Compactor compactor, int pageSize, CheckpointConfiguration checkpointConfig, LogSyncer logSyncer, PartitionDestructionLockManager partitionDestructionLockManager) {
        super(LOG, igniteInstanceName, "checkpoint-thread");
        this.pauseDetector = detector;
        this.pageSize = pageSize;
        this.checkpointConfig = checkpointConfig;
        this.checkpointWorkflow = checkpointWorkFlow;
        this.checkpointPagesWriterFactory = factory;
        this.filePageStoreManager = filePageStoreManager;
        this.compactor = compactor;
        this.failureManager = failureManager;
        this.logSyncer = logSyncer;
        this.partitionMetaManager = partitionMetaManager;
        this.partitionDestructionLockManager = partitionDestructionLockManager;
        this.scheduledCheckpointProgress = new CheckpointProgressImpl(TimeUnit.MILLISECONDS.toNanos(this.nextCheckpointInterval()));
        int checkpointWritePageThreads = checkpointConfig.checkpointThreads();
        this.checkpointWritePagesPool = checkpointWritePageThreads > 1 ? new ThreadPoolExecutor(checkpointWritePageThreads, checkpointWritePageThreads, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)((Object)IgniteCheckpointThreadFactory.create(igniteInstanceName, "checkpoint-runner-io", false, this.log, new ThreadOperation[0]))) : null;
    }

    protected void body() {
        try {
            while (!this.isCancelled()) {
                this.waitCheckpointEvent();
                if (this.isCancelled() || this.shutdownNow) {
                    this.log.info("Skipping last checkpoint because node is stopping", new Object[0]);
                    return;
                }
                this.doCheckpoint();
            }
            if (!this.shutdownNow) {
                this.doCheckpoint();
            }
            if (!this.isCancelled.get()) {
                throw new IllegalStateException("Thread is terminated unexpectedly: " + this.name());
            }
            this.scheduledCheckpointProgress.fail((Throwable)new NodeStoppingException("Node is stopping."));
        }
        catch (Throwable t) {
            this.scheduledCheckpointProgress.fail(t);
            if (t instanceof OutOfMemoryError) {
                this.failureManager.process(new FailureContext(FailureType.CRITICAL_ERROR, t));
            } else {
                this.failureManager.process(new FailureContext(FailureType.SYSTEM_WORKER_TERMINATION, t));
            }
            throw new IgniteInternalException(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CheckpointProgress scheduleCheckpoint(long delayFromNow, String reason) {
        CheckpointProgressImpl current = this.currentCheckpointProgress;
        if (current != null && !current.greaterOrEqualTo(CheckpointState.LOCK_TAKEN)) {
            return current;
        }
        current = this.scheduledCheckpointProgress;
        long nextNanos = System.nanoTime() + TimeUnit.MILLISECONDS.toNanos(delayFromNow);
        if (current.nextCheckpointNanos() - nextNanos <= 0L) {
            return current;
        }
        Checkpointer checkpointer = this;
        synchronized (checkpointer) {
            current = this.scheduledCheckpointProgress;
            if (current.nextCheckpointNanos() - nextNanos > 0L) {
                current.reason(reason);
                current.nextCheckpointNanos(TimeUnit.MILLISECONDS.toNanos(delayFromNow));
            }
            ((Object)((Object)this)).notifyAll();
        }
        return current;
    }

    void markPartitionAsDirty(DataRegion<?> dataRegion, int groupId, int partitionId, int partitionGeneration) {
        this.checkpointWorkflow.markPartitionAsDirty(dataRegion, groupId, partitionId, partitionGeneration);
    }

    void doCheckpoint() throws IgniteInternalCheckedException {
        Checkpoint chp = null;
        try {
            CheckpointMetricsTracker tracker = new CheckpointMetricsTracker();
            tracker.onCheckpointStart();
            CheckpointProgressImpl currentCheckpointProgress = this.startCheckpointProgress();
            try {
                chp = this.checkpointWorkflow.markCheckpointBegin(this.lastCheckpointTimestamp, currentCheckpointProgress, tracker, () -> ((Checkpointer)this).updateHeartbeat(), this::updateLastProgressAfterReleaseWriteLock);
            }
            catch (Exception e) {
                if (currentCheckpointProgress != null) {
                    currentCheckpointProgress.fail(e);
                }
                this.failureManager.process(new FailureContext(FailureType.CRITICAL_ERROR, (Throwable)e));
                throw new IgniteInternalCheckedException((Throwable)e);
            }
            this.updateHeartbeat();
            if (chp.hasDelta()) {
                if (this.log.isInfoEnabled()) {
                    long possibleJvmPauseDuration = this.possibleLongJvmPauseDuration(tracker);
                    if (this.log.isInfoEnabled()) {
                        this.log.info(CHECKPOINT_STARTED_LOG_TEMPLATE, new Object[]{chp.progress.id(), tracker.beforeWriteLockDuration(TimeUnit.MILLISECONDS), tracker.writeLockWaitDuration(TimeUnit.MICROSECONDS), tracker.onMarkCheckpointBeginDuration(TimeUnit.MICROSECONDS), tracker.writeLockHoldDuration(TimeUnit.MICROSECONDS), tracker.splitAndSortCheckpointPagesDuration(TimeUnit.MILLISECONDS), possibleJvmPauseDuration > 0L ? "possibleJvmPauseDuration=" + possibleJvmPauseDuration + "ms, " : "", chp.dirtyPagesSize, chp.progress.reason()});
                    }
                }
                this.replicatorLogSync(tracker);
                if (!this.writePages(tracker, chp.dirtyPages, chp.progress, (WorkProgressDispatcher)this, this::isShutdownNow)) {
                    return;
                }
            } else if (this.log.isInfoEnabled()) {
                this.log.info(CHECKPOINT_SKIPPED_LOG_TEMPLATE, new Object[]{tracker.beforeWriteLockDuration(TimeUnit.MILLISECONDS), tracker.writeLockWaitDuration(TimeUnit.MICROSECONDS), tracker.onMarkCheckpointBeginDuration(TimeUnit.MICROSECONDS), tracker.writeLockHoldDuration(TimeUnit.MICROSECONDS), chp.progress.reason()});
            }
            currentCheckpointProgress.setPagesWriteTimeMillis(tracker.pagesWriteDuration(TimeUnit.MILLISECONDS) + tracker.splitAndSortCheckpointPagesDuration(TimeUnit.MILLISECONDS));
            currentCheckpointProgress.setFsyncTimeMillis(tracker.fsyncDuration(TimeUnit.MILLISECONDS));
            this.checkpointWorkflow.markCheckpointEnd(chp);
            tracker.onCheckpointEnd();
            if (chp.hasDelta() && this.log.isInfoEnabled()) {
                long totalWriteBytes = (long)this.pageSize * (long)chp.dirtyPagesSize;
                long totalDurationInNanos = tracker.checkpointDuration(TimeUnit.NANOSECONDS);
                this.log.info(CHECKPOINT_FINISHED_LOG_TEMPLATE, new Object[]{chp.progress.id(), chp.dirtyPagesSize, tracker.pagesWriteDuration(TimeUnit.MILLISECONDS), tracker.fsyncDuration(TimeUnit.MILLISECONDS), tracker.replicatorLogSyncDuration(TimeUnit.MILLISECONDS), tracker.waitPageReplacementDuration(TimeUnit.MILLISECONDS), tracker.checkpointDuration(TimeUnit.MILLISECONDS), WriteSpeedFormatter.formatWriteSpeed(totalWriteBytes, totalDurationInNanos)});
            }
        }
        catch (IgniteInternalCheckedException e) {
            if (chp != null) {
                chp.progress.fail(e);
            }
            this.failureManager.process(new FailureContext(FailureType.CRITICAL_ERROR, (Throwable)e));
            throw e;
        }
        finally {
            this.currentCheckpointProgressForThrottling = null;
        }
    }

    private boolean writePages(CheckpointMetricsTracker tracker, CheckpointDirtyPages checkpointDirtyPages, CheckpointProgressImpl currentCheckpointProgress, WorkProgressDispatcher workProgressDispatcher, BooleanSupplier shutdownNow) throws IgniteInternalCheckedException {
        ThreadPoolExecutor pageWritePool = this.checkpointWritePagesPool;
        int checkpointWritePageThreads = pageWritePool == null ? 1 : pageWritePool.getMaximumPoolSize();
        ConcurrentHashMap<GroupPartitionId, LongAdder> updatedPartitions = new ConcurrentHashMap<GroupPartitionId, LongAdder>();
        CompletableFuture[] futures = new CompletableFuture[checkpointWritePageThreads];
        tracker.onPagesWriteStart();
        List<PersistentPageMemory> pageMemoryList = checkpointDirtyPages.dirtyPageMemoryInstances();
        IgniteConcurrentMultiPairQueue<PersistentPageMemory, GroupPartitionId> dirtyPartitionQueue = checkpointDirtyPages.toDirtyPartitionQueue();
        for (int i = 0; i < checkpointWritePageThreads; ++i) {
            futures[i] = new CompletableFuture();
            CheckpointPagesWriter write = this.checkpointPagesWriterFactory.build(tracker, dirtyPartitionQueue, pageMemoryList, updatedPartitions, futures[i], () -> ((WorkProgressDispatcher)workProgressDispatcher).updateHeartbeat(), currentCheckpointProgress, shutdownNow);
            if (pageWritePool == null) {
                write.run();
                continue;
            }
            pageWritePool.execute(write);
        }
        workProgressDispatcher.updateHeartbeat();
        CompletableFuture.allOf(futures).join();
        tracker.onPagesWriteEnd();
        if (shutdownNow.getAsBoolean()) {
            currentCheckpointProgress.fail((Throwable)new NodeStoppingException("Node is stopping."));
            return false;
        }
        tracker.onWaitPageReplacementStart();
        currentCheckpointProgress.getUnblockFsyncOnPageReplacementFuture().join();
        tracker.onWaitPageReplacementEnd();
        if (shutdownNow.getAsBoolean()) {
            currentCheckpointProgress.fail((Throwable)new NodeStoppingException("Node is stopping."));
            return false;
        }
        tracker.onFsyncStart();
        this.syncUpdatedPageStores(updatedPartitions, currentCheckpointProgress);
        tracker.onFsyncEnd();
        this.compactor.triggerCompaction();
        if (shutdownNow.getAsBoolean()) {
            currentCheckpointProgress.fail((Throwable)new NodeStoppingException("Node is stopping."));
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncUpdatedPageStores(ConcurrentMap<GroupPartitionId, LongAdder> updatedPartitions, CheckpointProgressImpl currentCheckpointProgress) throws IgniteInternalCheckedException {
        ThreadPoolExecutor pageWritePool = this.checkpointWritePagesPool;
        if (pageWritePool == null) {
            for (Map.Entry entry : updatedPartitions.entrySet()) {
                if (this.shutdownNow) {
                    return;
                }
                this.fsyncPartitionFiles(currentCheckpointProgress, (GroupPartitionId)entry.getKey(), (LongAdder)entry.getValue());
            }
        } else {
            int checkpointThreads = pageWritePool.getMaximumPoolSize();
            CompletableFuture[] futures = new CompletableFuture[checkpointThreads];
            for (int i = 0; i < checkpointThreads; ++i) {
                futures[i] = new CompletableFuture();
            }
            LinkedBlockingQueue queue = new LinkedBlockingQueue(updatedPartitions.entrySet());
            int i = 0;
            while (i < checkpointThreads) {
                int threadIdx = i++;
                pageWritePool.execute(() -> {
                    Map.Entry entry = (Map.Entry)queue.poll();
                    try {
                        while (entry != null && !this.shutdownNow) {
                            this.fsyncPartitionFiles(currentCheckpointProgress, (GroupPartitionId)entry.getKey(), (LongAdder)entry.getValue());
                            entry = (Map.Entry)queue.poll();
                        }
                        futures[threadIdx].complete(null);
                    }
                    catch (Throwable t) {
                        futures[threadIdx].completeExceptionally(t);
                    }
                });
            }
            this.blockingSectionBegin();
            try {
                CompletableFuture.allOf(futures).join();
            }
            finally {
                this.blockingSectionEnd();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fsyncPartitionFiles(CheckpointProgressImpl currentCheckpointProgress, GroupPartitionId partitionId, LongAdder pagesWritten) throws IgniteInternalCheckedException {
        FilePageStore filePageStore = this.filePageStoreManager.getStore(partitionId);
        if (filePageStore == null || filePageStore.isMarkedToDestroy()) {
            return;
        }
        Lock partitionDestructionLock = this.partitionDestructionLockManager.destructionLock(partitionId).readLock();
        partitionDestructionLock.lock();
        try {
            PartitionMeta meta = this.partitionMetaManager.getMeta(partitionId);
            if (meta == null) {
                return;
            }
            this.fsyncDeltaFilePageStoreOnCheckpointThread(filePageStore);
            this.fsyncFilePageStoreOnCheckpointThread(filePageStore);
            this.renameDeltaFileOnCheckpointThread(filePageStore, partitionId);
            filePageStore.checkpointedPageCount(meta.metaSnapshot(currentCheckpointProgress.id()).pageCount());
            currentCheckpointProgress.syncedPagesCounter().addAndGet(pagesWritten.intValue());
        }
        finally {
            partitionDestructionLock.unlock();
        }
    }

    private void fsyncFilePageStoreOnCheckpointThread(FilePageStore filePageStore) throws IgniteInternalCheckedException {
        this.blockingSectionBegin();
        try {
            filePageStore.sync();
        }
        finally {
            this.blockingSectionEnd();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void waitCheckpointEvent() {
        try {
            Checkpointer checkpointer = this;
            synchronized (checkpointer) {
                long remaining = TimeUnit.NANOSECONDS.toMillis(this.scheduledCheckpointProgress.nextCheckpointNanos() - System.nanoTime());
                while (remaining > 0L && !this.isCancelled()) {
                    this.blockingSectionBegin();
                    try {
                        ((Object)((Object)this)).wait(remaining);
                        remaining = TimeUnit.NANOSECONDS.toMillis(this.scheduledCheckpointProgress.nextCheckpointNanos() - System.nanoTime());
                    }
                    finally {
                        this.blockingSectionEnd();
                    }
                }
            }
        }
        catch (InterruptedException ignored) {
            Thread.currentThread().interrupt();
            this.isCancelled.set(true);
        }
    }

    private long possibleLongJvmPauseDuration(CheckpointMetricsTracker tracker) {
        long lockDuration;
        if (this.pauseDetector != null && (lockDuration = tracker.writeLockWaitDuration(TimeUnit.MILLISECONDS) + tracker.writeLockHoldDuration(TimeUnit.MILLISECONDS)) > this.pauseDetector.longJvmPauseThreshold()) {
            long now = FastTimestamps.coarseCurrentTimeMillis();
            long wakeUpTime = this.pauseDetector.getLastWakeUpTime();
            IgniteBiTuple lastLongPause = this.pauseDetector.getLastLongPause();
            if (lastLongPause != null && tracker.checkpointStartTime() < (Long)lastLongPause.get1()) {
                return (Long)lastLongPause.get2();
            }
            if (now - wakeUpTime > this.pauseDetector.longJvmPauseThreshold()) {
                return now - wakeUpTime;
            }
        }
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CheckpointProgressImpl startCheckpointProgress() {
        long checkpointStartTimestamp = FastTimestamps.coarseCurrentTimeMillis();
        if (checkpointStartTimestamp == this.lastCheckpointTimestamp) {
            ++checkpointStartTimestamp;
        }
        this.lastCheckpointTimestamp = checkpointStartTimestamp;
        Checkpointer checkpointer = this;
        synchronized (checkpointer) {
            CheckpointProgressImpl curr = this.scheduledCheckpointProgress;
            if (curr.reason() == null) {
                curr.reason("timeout");
            }
            this.scheduledCheckpointProgress = new CheckpointProgressImpl(TimeUnit.MILLISECONDS.toNanos(this.nextCheckpointInterval()));
            this.currentCheckpointProgress = curr;
            curr.futureFor(CheckpointState.PAGES_SNAPSHOT_TAKEN).thenRun(() -> {
                this.currentCheckpointProgressForThrottling = curr;
            });
            return curr;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Cancelling grid runnable: " + this, new Object[0]);
        }
        this.isCancelled.set(true);
        Checkpointer checkpointer = this;
        synchronized (checkpointer) {
            ((Object)((Object)this)).notifyAll();
        }
    }

    public void shutdownNow() {
        this.shutdownNow = true;
        if (!this.isCancelled.get()) {
            this.cancel();
        }
    }

    public void start() {
        if (this.runner() != null) {
            return;
        }
        assert (this.runner() == null) : "Checkpointer is running.";
        new IgniteThread((IgniteWorker)this).start();
    }

    public void stop() throws Exception {
        this.shutdownCheckpointer(true);
    }

    public void shutdownCheckpointer(boolean shutdown) {
        if (shutdown) {
            this.shutdownNow();
        } else {
            this.cancel();
        }
        try {
            this.join();
        }
        catch (InterruptedException ignore) {
            this.log.info("Was interrupted while waiting for checkpointer shutdown, will not wait for checkpoint to finish", new Object[0]);
            Thread.currentThread().interrupt();
            this.shutdownNow();
            while (true) {
                try {
                    this.join();
                    this.scheduledCheckpointProgress.fail((Throwable)new NodeStoppingException("Checkpointer is stopped during node stop."));
                }
                catch (InterruptedException ignored) {
                    Thread.currentThread().interrupt();
                    continue;
                }
                break;
            }
            Thread.currentThread().interrupt();
        }
        if (this.checkpointWritePagesPool != null) {
            IgniteUtils.shutdownAndAwaitTermination((ExecutorService)this.checkpointWritePagesPool, (long)2L, (TimeUnit)TimeUnit.MINUTES);
        }
    }

    @Nullable
    CheckpointProgress currentCheckpointProgress() {
        return this.currentCheckpointProgress;
    }

    @Nullable
    public CheckpointProgress currentCheckpointProgressForThrottling() {
        return this.currentCheckpointProgressForThrottling;
    }

    @Nullable
    public CheckpointProgress lastCheckpointProgress() {
        return this.afterReleaseWriteLockCheckpointProgress;
    }

    CheckpointProgress scheduledProgress() {
        return this.scheduledCheckpointProgress;
    }

    boolean isShutdownNow() {
        return this.shutdownNow;
    }

    long nextCheckpointInterval() {
        long interval = this.checkpointConfig.intervalMillis();
        int deviation = this.checkpointConfig.intervalDeviationPercent();
        if (deviation == 0) {
            return interval;
        }
        long deviationMillis = interval * (long)deviation;
        long startDelay = ThreadLocalRandom.current().nextLong(Math.max(IgniteUtils.safeAbs((long)deviationMillis) / 100L, 1L)) - Math.max(IgniteUtils.safeAbs((long)deviationMillis) / 200L, 1L);
        return IgniteUtils.safeAbs((long)(interval + startDelay));
    }

    private void fsyncDeltaFilePageStoreOnCheckpointThread(FilePageStore filePageStore) throws IgniteInternalCheckedException {
        this.blockingSectionBegin();
        try {
            CompletableFuture<DeltaFilePageStoreIo> deltaFilePageStoreFuture = filePageStore.getNewDeltaFile();
            if (deltaFilePageStoreFuture == null) {
                return;
            }
            deltaFilePageStoreFuture.join().sync();
        }
        finally {
            this.blockingSectionEnd();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renameDeltaFileOnCheckpointThread(FilePageStore filePageStore, GroupPartitionId partitionId) throws IgniteInternalCheckedException {
        this.blockingSectionBegin();
        try {
            CompletableFuture<DeltaFilePageStoreIo> deltaFilePageStoreFuture = filePageStore.getNewDeltaFile();
            if (deltaFilePageStoreFuture == null) {
                return;
            }
            DeltaFilePageStoreIo deltaFilePageStoreIo = deltaFilePageStoreFuture.join();
            Path newDeltaFilePath = this.filePageStoreManager.deltaFilePageStorePath(partitionId.getGroupId(), partitionId.getPartitionId(), deltaFilePageStoreIo.fileIndex());
            try {
                deltaFilePageStoreIo.renameFilePath(newDeltaFilePath);
            }
            catch (IOException e) {
                throw new IgniteInternalCheckedException("Error when renaming delta file: " + deltaFilePageStoreIo.filePath(), (Throwable)e);
            }
            filePageStore.completeNewDeltaFile();
        }
        finally {
            this.blockingSectionEnd();
        }
    }

    void updateLastProgressAfterReleaseWriteLock() {
        this.afterReleaseWriteLockCheckpointProgress = this.currentCheckpointProgress;
    }

    private void replicatorLogSync(CheckpointMetricsTracker tracker) throws IgniteInternalCheckedException {
        try {
            tracker.onReplicatorLogSyncStart();
            this.logSyncer.sync();
            tracker.onReplicatorLogSyncEnd();
        }
        catch (Exception e) {
            this.log.error("Failed to sync write-ahead log during checkpoint", (Throwable)e);
            throw new IgniteInternalCheckedException((Throwable)e);
        }
    }
}

