/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.pagememory.persistence.store;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import org.apache.ignite.internal.fileio.FileIo;
import org.apache.ignite.internal.fileio.FileIoFactory;
import org.apache.ignite.internal.lang.IgniteInternalCheckedException;
import org.apache.ignite.internal.pagememory.persistence.store.DeltaFilePageStoreIo;
import org.apache.ignite.internal.pagememory.persistence.store.DeltaFilePageStoreIoHeader;
import org.apache.ignite.internal.pagememory.persistence.store.FilePageStore;
import org.apache.ignite.internal.pagememory.persistence.store.FilePageStoreHeader;
import org.apache.ignite.internal.pagememory.persistence.store.FilePageStoreIo;

public class FilePageStoreFactory {
    private final FileIoFactory fileIoFactory;
    private final int pageSize;

    public FilePageStoreFactory(FileIoFactory fileIoFactory, int pageSize) {
        this.fileIoFactory = fileIoFactory;
        this.pageSize = pageSize;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public FilePageStore createPageStore(ByteBuffer headerBuffer, Path filePageStorePath, Path ... deltaFilePaths) throws IgniteInternalCheckedException {
        assert (headerBuffer.remaining() == this.pageSize) : headerBuffer.remaining();
        if (!Files.exists(filePageStorePath, new LinkOption[0])) {
            if ($assertionsDisabled) return this.createFilePageStore(filePageStorePath, new FilePageStoreHeader(1, this.pageSize), new DeltaFilePageStoreIo[0]);
            if (deltaFilePaths.length == 0) return this.createFilePageStore(filePageStorePath, new FilePageStoreHeader(1, this.pageSize), new DeltaFilePageStoreIo[0]);
            throw new AssertionError((Object)Arrays.toString(deltaFilePaths));
        }
        try (FileIo fileIo = this.fileIoFactory.create(filePageStorePath);){
            FilePageStoreHeader header = FilePageStoreHeader.readHeader(fileIo, headerBuffer);
            if (header == null) {
                header = new FilePageStoreHeader(1, this.pageSize);
            }
            if (deltaFilePaths.length == 0) {
                FilePageStore filePageStore2 = this.createFilePageStore(filePageStorePath, header, new DeltaFilePageStoreIo[0]);
                return filePageStore2;
            }
            DeltaFilePageStoreIo[] deltaFileIos = new DeltaFilePageStoreIo[deltaFilePaths.length];
            for (int i = 0; i < deltaFilePaths.length; ++i) {
                Path deltaFilePath = deltaFilePaths[i];
                assert (Files.exists(deltaFilePath, new LinkOption[0])) : deltaFilePath;
                try (FileIo deltaFileIo = this.fileIoFactory.create(deltaFilePath);){
                    DeltaFilePageStoreIoHeader deltaFileHeader = DeltaFilePageStoreIoHeader.readHeader(deltaFileIo, headerBuffer.rewind());
                    assert (deltaFileHeader != null) : deltaFileHeader;
                    deltaFileIos[i] = this.createDeltaFilePageStoreIo(deltaFilePath, deltaFileHeader);
                    continue;
                }
                catch (IOException e) {
                    throw new IgniteInternalCheckedException("Error while creating delta file page store [file=" + deltaFilePath + "]", (Throwable)e);
                }
            }
            FilePageStore filePageStore = this.createFilePageStore(filePageStorePath, header, deltaFileIos);
            return filePageStore;
        }
        catch (IOException e) {
            throw new IgniteInternalCheckedException("Error while creating file page store [file=" + filePageStorePath + "]", (Throwable)e);
        }
    }

    private FilePageStore createFilePageStore(Path filePath, FilePageStoreHeader header, DeltaFilePageStoreIo ... deltaFileIos) throws IgniteInternalCheckedException {
        if (header.version() == 1) {
            return new FilePageStore(new FilePageStoreIo(this.fileIoFactory, filePath, header), deltaFileIos);
        }
        throw new IgniteInternalCheckedException(String.format("Unknown version of file page store [version=%s, file=%s]", header.version(), filePath));
    }

    private DeltaFilePageStoreIo createDeltaFilePageStoreIo(Path filePath, DeltaFilePageStoreIoHeader header) throws IgniteInternalCheckedException {
        if (header.version() == 1) {
            return new DeltaFilePageStoreIo(this.fileIoFactory, filePath, header);
        }
        throw new IgniteInternalCheckedException(String.format("Unknown version of delta file page store [version=%s, file=%s]", header.version(), filePath));
    }
}

