/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.mem;

import java.util.Arrays;
import java.util.stream.IntStream;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.mem.NumaAllocUtil;
import org.apache.ignite.internal.util.GridUnsafe;
import org.apache.ignite.mem.InterleavedNumaAllocationStrategy;
import org.apache.ignite.mem.LocalNumaAllocationStrategy;
import org.apache.ignite.mem.NumaAllocationStrategy;
import org.apache.ignite.mem.NumaAllocator;
import org.apache.ignite.mem.SimpleNumaAllocationStrategy;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Test;
import org.junit.experimental.runners.Enclosed;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Enclosed.class)
public class NumaAllocatorUnitTest {

    public static class ErrorScenarioTest
    extends GridCommonAbstractTest {
        @Test
        public void testInvalidInterleavedStrategyParams() {
            int[][] invalidNodes;
            for (int[] nodeSet : invalidNodes = new int[][]{{-3, -4, 0}, IntStream.range(0, NumaAllocUtil.NUMA_NODES_CNT + 1).toArray()}) {
                GridTestUtils.assertThrows((IgniteLogger)this.log(), () -> new InterleavedNumaAllocationStrategy(nodeSet), IllegalArgumentException.class, null);
            }
        }

        @Test
        public void testInvalidSimpleStrategyParams() {
            int[] invalidNodes;
            for (int node : invalidNodes = new int[]{-3, NumaAllocUtil.NUMA_NODES_CNT}) {
                GridTestUtils.assertThrows((IgniteLogger)this.log(), () -> new SimpleNumaAllocationStrategy(node), IllegalArgumentException.class, null);
            }
        }
    }

    @RunWith(value=Parameterized.class)
    public static class PositiveScenarioTest
    extends GridCommonAbstractTest {
        private static final long BUF_SZ = 0x2000000L;
        private static final int[] EVEN_NODES = IntStream.range(0, NumaAllocUtil.NUMA_NODES_CNT).filter(x -> x % 2 == 0).toArray();
        private static final int[] ALL_NODES = IntStream.range(0, NumaAllocUtil.NUMA_NODES_CNT).toArray();
        @Parameterized.Parameter
        public NumaAllocationStrategy strategy;

        @Parameterized.Parameters(name="allocationStrategy={0}")
        public static Iterable<Object[]> data() {
            return Arrays.asList({new LocalNumaAllocationStrategy()}, {new InterleavedNumaAllocationStrategy()}, {new InterleavedNumaAllocationStrategy(new int[0])}, {new InterleavedNumaAllocationStrategy(EVEN_NODES)}, {new InterleavedNumaAllocationStrategy(ALL_NODES)}, {new SimpleNumaAllocationStrategy()}, {new SimpleNumaAllocationStrategy(NumaAllocUtil.NUMA_NODES_CNT - 1)});
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Test
        public void test() {
            NumaAllocator allocator = new NumaAllocator(this.strategy);
            long ptr = 0L;
            try {
                ptr = allocator.allocateMemory(0x2000000L);
                PositiveScenarioTest.assertEquals((long)0x2000000L, (long)NumaAllocUtil.chunkSize((long)ptr));
                GridUnsafe.setMemory((long)ptr, (long)0x2000000L, (byte)1);
                for (long i = 0L; i < 0x2000000L; ++i) {
                    PositiveScenarioTest.assertEquals((byte)1, (byte)GridUnsafe.getByte((long)(ptr + i)));
                }
            }
            finally {
                if (ptr != 0L) {
                    allocator.freeMemory(ptr);
                }
            }
        }
    }
}

