/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.mem;

import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteDataStreamer;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.mem.NumaAllocUtil;
import org.apache.ignite.internal.processors.cache.persistence.DataRegion;
import org.apache.ignite.internal.util.typedef.G;
import org.apache.ignite.mem.InterleavedNumaAllocationStrategy;
import org.apache.ignite.mem.LocalNumaAllocationStrategy;
import org.apache.ignite.mem.MemoryAllocator;
import org.apache.ignite.mem.NumaAllocationStrategy;
import org.apache.ignite.mem.NumaAllocator;
import org.apache.ignite.mem.SimpleNumaAllocationStrategy;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class NumaAllocatorBasicTest
extends GridCommonAbstractTest {
    private static final long INITIAL_SIZE = 0x1E00000L;
    private static final long MAX_SIZE = 0x6400000L;
    private static final String TEST_CACHE = "test";
    private static final byte[] BUF = new byte[4096];
    private static final int NUM_NODES = 3;
    @Parameterized.Parameter(value=0)
    public NumaAllocationStrategy strategy;
    @Parameterized.Parameter(value=1)
    public boolean defaultConfig;

    @Parameterized.Parameters(name="allocationStrategy={0}, defaultConfig={1}")
    public static Iterable<Object[]> data() {
        return Stream.of(new LocalNumaAllocationStrategy(), new InterleavedNumaAllocationStrategy(), new InterleavedNumaAllocationStrategy(IntStream.range(0, NumaAllocUtil.NUMA_NODES_CNT).toArray()), new SimpleNumaAllocationStrategy(), new SimpleNumaAllocationStrategy(NumaAllocUtil.NUMA_NODES_CNT - 1)).flatMap(strategy -> Stream.of({strategy, true}, {strategy, false})).collect(Collectors.toList());
    }

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        DataStorageConfiguration memCfg = new DataStorageConfiguration();
        DataRegionConfiguration dfltReg = new DataRegionConfiguration().setInitialSize(0x1E00000L).setMaxSize(0x6400000L).setMetricsEnabled(true);
        NumaAllocator memAlloc = new NumaAllocator(this.strategy);
        if (this.defaultConfig) {
            memCfg.setMemoryAllocator((MemoryAllocator)memAlloc);
        } else {
            dfltReg.setMemoryAllocator((MemoryAllocator)memAlloc);
        }
        memCfg.setDefaultDataRegionConfiguration(dfltReg);
        cfg.setDataStorageConfiguration(memCfg);
        return cfg;
    }

    protected void beforeTest() throws Exception {
        super.beforeTest();
        this.startGrids(3);
    }

    protected void afterTest() throws Exception {
        super.afterTest();
        this.stopAllGrids(true);
    }

    @Test
    public void testLoadData() throws Exception {
        IgniteEx client = this.startClientGrid("client");
        client.getOrCreateCache(TEST_CACHE);
        try (IgniteDataStreamer ds = client.dataStreamer(TEST_CACHE);){
            int cnt = 0;
            while (this.hasFreeSpace()) {
                ds.addData((Object)(++cnt), (Object)BUF);
                if (cnt % 100 != 0) continue;
                ds.flush();
            }
        }
        NumaAllocatorBasicTest.assertEquals((long)3L, (long)NumaAllocatorBasicTest.serverGrids().count());
        NumaAllocatorBasicTest.serverGrids().forEach(g -> NumaAllocatorBasicTest.assertTrue((boolean)(NumaAllocatorBasicTest.getDefaultRegion(g).config().getMemoryAllocator() instanceof NumaAllocator)));
    }

    private boolean hasFreeSpace() {
        return NumaAllocatorBasicTest.serverGrids().allMatch(g -> {
            DataRegion dr = NumaAllocatorBasicTest.getDefaultRegion(g);
            return (double)dr.metrics().getTotalAllocatedSize() < 9.437184E7;
        });
    }

    private static Stream<IgniteEx> serverGrids() {
        return G.allGrids().stream().filter(g -> !g.cluster().localNode().isClient()).map(g -> (IgniteEx)g);
    }

    private static DataRegion getDefaultRegion(IgniteEx g) {
        NumaAllocatorBasicTest.assertFalse((boolean)g.cluster().localNode().isClient());
        String dataRegionName = g.configuration().getDataStorageConfiguration().getDefaultDataRegionConfiguration().getName();
        try {
            return g.context().cache().context().database().dataRegion(dataRegionName);
        }
        catch (IgniteCheckedException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        ThreadLocalRandom.current().nextBytes(BUF);
    }
}

