/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.network.scalecube;

import io.scalecube.cluster.Cluster;
import io.scalecube.cluster.ClusterConfig;
import io.scalecube.cluster.ClusterImpl;
import io.scalecube.cluster.ClusterMessageHandler;
import io.scalecube.cluster.Member;
import io.scalecube.cluster.membership.MembershipEvent;
import io.scalecube.cluster.metadata.MetadataCodec;
import io.scalecube.net.Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.ignite.internal.failure.FailureProcessor;
import org.apache.ignite.internal.lang.IgniteInternalException;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.manager.ComponentContext;
import org.apache.ignite.internal.network.AbstractClusterService;
import org.apache.ignite.internal.network.ChannelTypeRegistry;
import org.apache.ignite.internal.network.ClusterIdSupplier;
import org.apache.ignite.internal.network.ClusterNodeImpl;
import org.apache.ignite.internal.network.ClusterService;
import org.apache.ignite.internal.network.DefaultMessagingService;
import org.apache.ignite.internal.network.InternalClusterNode;
import org.apache.ignite.internal.network.MessagingService;
import org.apache.ignite.internal.network.NettyBootstrapFactory;
import org.apache.ignite.internal.network.NetworkMessagesFactory;
import org.apache.ignite.internal.network.NodeFinder;
import org.apache.ignite.internal.network.NodeFinderFactory;
import org.apache.ignite.internal.network.TopologyEventHandler;
import org.apache.ignite.internal.network.TopologyService;
import org.apache.ignite.internal.network.configuration.ClusterMembershipView;
import org.apache.ignite.internal.network.configuration.NetworkConfiguration;
import org.apache.ignite.internal.network.configuration.NetworkView;
import org.apache.ignite.internal.network.configuration.ScaleCubeView;
import org.apache.ignite.internal.network.netty.ConnectionManager;
import org.apache.ignite.internal.network.recovery.StaleIds;
import org.apache.ignite.internal.network.scalecube.ScaleCubeDirectMarshallerTransport;
import org.apache.ignite.internal.network.scalecube.ScaleCubeTopologyService;
import org.apache.ignite.internal.network.serialization.ClassDescriptorFactory;
import org.apache.ignite.internal.network.serialization.ClassDescriptorRegistry;
import org.apache.ignite.internal.network.serialization.MessageSerializationRegistry;
import org.apache.ignite.internal.network.serialization.SerializationService;
import org.apache.ignite.internal.network.serialization.UserObjectSerializationContext;
import org.apache.ignite.internal.network.serialization.marshal.DefaultUserObjectMarshaller;
import org.apache.ignite.internal.util.CompletableFutures;
import org.apache.ignite.internal.version.IgniteProductVersionSource;
import org.apache.ignite.internal.worker.CriticalWorkerRegistry;
import org.apache.ignite.network.NetworkAddress;
import org.apache.ignite.network.NodeMetadata;
import org.gridgain.internal.upgrade.RollingUpgradeManager;

public class ScaleCubeClusterServiceFactory {
    private static final IgniteLogger LOG = Loggers.forClass(ScaleCubeClusterServiceFactory.class);
    private static final MetadataCodec METADATA_CODEC = MetadataCodec.INSTANCE;

    public ClusterService createClusterService(final String consistentId, final NetworkConfiguration networkConfiguration, final NettyBootstrapFactory nettyBootstrapFactory, final MessageSerializationRegistry serializationRegistry, final StaleIds staleIds, final ClusterIdSupplier clusterIdSupplier, CriticalWorkerRegistry criticalWorkerRegistry, final FailureProcessor failureProcessor, final ChannelTypeRegistry channelTypeRegistry, final IgniteProductVersionSource productVersionSource, Supplier<RollingUpgradeManager> rollingUpgradeManagerFactory) {
        final ScaleCubeTopologyService topologyService = new ScaleCubeTopologyService();
        topologyService.addEventHandler(new TopologyEventHandler(){

            public void onDisappeared(InternalClusterNode member) {
                staleIds.markAsStale(member.id());
            }
        });
        final NetworkMessagesFactory messageFactory = new NetworkMessagesFactory();
        final UserObjectSerializationContext userObjectSerialization = this.createUserObjectSerializationContext();
        final DefaultMessagingService messagingService = new DefaultMessagingService(consistentId, messageFactory, (TopologyService)topologyService, staleIds, userObjectSerialization.descriptorRegistry(), userObjectSerialization.marshaller(), criticalWorkerRegistry, failureProcessor, channelTypeRegistry);
        return new AbstractClusterService(consistentId, (TopologyService)topologyService, (MessagingService)messagingService, serializationRegistry){
            private volatile ClusterImpl cluster;
            private volatile ConnectionManager connectionMgr;
            private volatile CompletableFuture<Void> shutdownFuture;

            public CompletableFuture<Void> startAsync(ComponentContext componentContext) {
                ConnectionManager connectionMgr;
                SerializationService serializationService = new SerializationService(serializationRegistry, userObjectSerialization);
                UUID launchId = UUID.randomUUID();
                NetworkView configView = (NetworkView)networkConfiguration.value();
                this.connectionMgr = connectionMgr = new ConnectionManager(configView, serializationService, consistentId, launchId, nettyBootstrapFactory, staleIds, clusterIdSupplier, channelTypeRegistry, productVersionSource, (TopologyService)topologyService, failureProcessor);
                connectionMgr.start();
                messagingService.start();
                Address scalecubeLocalAddress = ScaleCubeClusterServiceFactory.prepareAddress(connectionMgr.localBindAddress());
                topologyService.addEventHandler(new TopologyEventHandler(){

                    public void onDisappeared(InternalClusterNode member) {
                        connectionMgr.handleNodeLeft(member.id()).thenRun(() -> nettyBootstrapFactory.handshakeEventLoopSwitcher().nodeLeftTopology(member));
                    }
                });
                ScaleCubeDirectMarshallerTransport transport = new ScaleCubeDirectMarshallerTransport(scalecubeLocalAddress, (MessagingService)messagingService, messageFactory);
                ClusterConfig clusterConfig = ScaleCubeClusterServiceFactory.this.clusterConfig(configView.membership());
                NodeFinder finder = NodeFinderFactory.createNodeFinder(configView.nodeFinder(), this.nodeName(), connectionMgr.localBindAddress());
                finder.start();
                ClusterImpl cluster = new ClusterImpl(clusterConfig).handler(cl -> new ClusterMessageHandler(){

                    public void onMembershipEvent(MembershipEvent event) {
                        topologyService.onMembershipEvent(event);
                    }
                }).config(opts -> opts.memberId(launchId.toString()).memberAlias(consistentId).metadataCodec(METADATA_CODEC)).transport(opts -> opts.transportFactory(transportConfig -> transport)).membership(opts -> opts.seedMembers(ScaleCubeClusterServiceFactory.parseAddresses(finder.findNodes())));
                Member localMember = ScaleCubeClusterServiceFactory.this.createLocalMember(scalecubeLocalAddress, launchId, clusterConfig);
                ClusterNodeImpl localNode = new ClusterNodeImpl(UUID.fromString(localMember.id()), consistentId, new NetworkAddress(localMember.address().host(), localMember.address().port()));
                connectionMgr.setLocalNode((InternalClusterNode)localNode);
                this.shutdownFuture = cluster.onShutdown().toFuture().thenAccept(v -> finder.close());
                topologyService.setCluster((Cluster)cluster);
                messagingService.setConnectionManager(connectionMgr);
                cluster.startAwait();
                assert (cluster.member().equals((Object)localMember)) : "Expected local member from cluster " + cluster.member() + " to be equal to the precomputed one " + localMember;
                MembershipEvent localMembershipEvent = MembershipEvent.createAdded((Member)cluster.member(), null, (long)System.currentTimeMillis());
                topologyService.onMembershipEvent(localMembershipEvent);
                this.cluster = cluster;
                return CompletableFutures.nullCompletedFuture();
            }

            public CompletableFuture<Void> stopAsync(ComponentContext componentContext) {
                try {
                    ConnectionManager localConnectionMgr = this.connectionMgr;
                    if (localConnectionMgr != null) {
                        localConnectionMgr.initiateStopping();
                    }
                    if (this.cluster != null && this.cluster.member() != null) {
                        this.cluster.shutdown();
                        try {
                            this.shutdownFuture.get(10L, TimeUnit.SECONDS);
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                            throw new IgniteInternalException("Interrupted while waiting for the ClusterService to stop", (Throwable)e);
                        }
                        catch (ExecutionException e) {
                            throw new IgniteInternalException("Unable to stop the ClusterService", e.getCause());
                        }
                        catch (TimeoutException e) {
                            LOG.warn("Failed to wait for ScaleCube cluster shutdown [reason={}]", (Throwable)e, new Object[]{e.getMessage()});
                        }
                    }
                    if (localConnectionMgr != null) {
                        localConnectionMgr.stop();
                    }
                    messagingService.stop();
                    return CompletableFutures.nullCompletedFuture();
                }
                catch (Throwable t) {
                    return CompletableFuture.failedFuture(t);
                }
            }

            public void beforeNodeStop() {
                this.stopAsync(new ComponentContext()).join();
            }

            public boolean isStopped() {
                return this.shutdownFuture.isDone();
            }

            public void updateMetadata(NodeMetadata metadata) {
                this.cluster.updateMetadata((Object)metadata).subscribe();
                topologyService.updateLocalMetadata(metadata);
            }
        };
    }

    private static Address prepareAddress(InetSocketAddress addr) {
        InetAddress address = addr.getAddress();
        String host = address.isAnyLocalAddress() ? Address.getLocalIpAddress().getHostAddress() : address.getHostAddress();
        return Address.create((String)host, (int)addr.getPort());
    }

    private Member createLocalMember(Address address, UUID launchId, ClusterConfig config) {
        int port = Optional.ofNullable(config.externalPort()).orElse(address.port());
        Address memberAddress = Optional.ofNullable(config.externalHost()).map(host -> Address.create((String)host, (int)port)).orElseGet(() -> Address.create((String)address.host(), (int)port));
        return new Member(launchId.toString(), config.memberAlias(), memberAddress, config.membershipConfig().namespace());
    }

    protected ClusterConfig clusterConfig(ClusterMembershipView cfg) {
        ScaleCubeView scaleCube = cfg.scaleCube();
        return ClusterConfig.defaultLocalConfig().membership(opts -> opts.syncInterval(cfg.membershipSyncIntervalMillis()).suspicionMult(scaleCube.membershipSuspicionMultiplier())).failureDetector(opts -> opts.pingInterval(cfg.failurePingIntervalMillis()).pingReqMembers(scaleCube.failurePingRequestMembers())).gossip(opts -> opts.gossipInterval((long)scaleCube.gossipIntervalMillis()).gossipRepeatMult(scaleCube.gossipRepeatMult())).metadataTimeout(scaleCube.metadataTimeoutMillis());
    }

    private UserObjectSerializationContext createUserObjectSerializationContext() {
        ClassDescriptorRegistry userObjectDescriptorRegistry = new ClassDescriptorRegistry();
        ClassDescriptorFactory userObjectDescriptorFactory = new ClassDescriptorFactory(userObjectDescriptorRegistry);
        DefaultUserObjectMarshaller userObjectMarshaller = new DefaultUserObjectMarshaller(userObjectDescriptorRegistry, userObjectDescriptorFactory);
        return new UserObjectSerializationContext(userObjectDescriptorRegistry, userObjectDescriptorFactory, userObjectMarshaller);
    }

    private static List<Address> parseAddresses(Collection<NetworkAddress> addresses) {
        return addresses.stream().map(addr -> Address.create((String)addr.host(), (int)addr.port())).collect(Collectors.toList());
    }
}

