/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.network.netty;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.util.Attribute;
import io.netty.util.AttributeKey;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.network.NetworkMessage;
import org.apache.ignite.internal.network.message.ClassDescriptorListMessage;
import org.apache.ignite.internal.network.serialization.MessageDeserializer;
import org.apache.ignite.internal.network.serialization.MessageFormat;
import org.apache.ignite.internal.network.serialization.MessageReader;
import org.apache.ignite.internal.network.serialization.PerSessionSerializationService;

public class InboundDecoder
extends ByteToMessageDecoder {
    public static final String NAME = "inbound-decoder";
    private static final IgniteLogger LOG = Loggers.forClass(InboundDecoder.class);
    private static final AttributeKey<MessageReader> READER_KEY = AttributeKey.valueOf((String)"READER");
    private static final AttributeKey<MessageDeserializer<NetworkMessage>> DESERIALIZER_KEY = AttributeKey.valueOf((String)"DESERIALIZER");
    private static final AttributeKey<Short> GROUP_TYPE_KEY = AttributeKey.valueOf((String)"GROUP_TYPE");
    private MessageFormat messageFormat;
    private byte binaryStreamVersion = 1;
    private final PerSessionSerializationService serializationService;

    public InboundDecoder(MessageFormat messageFormat, PerSessionSerializationService serializationService) {
        this.messageFormat = messageFormat;
        this.serializationService = serializationService;
    }

    public void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) {
        ByteBuffer buffer = in.nioBuffer();
        Attribute readerAttr = ctx.channel().attr(READER_KEY);
        MessageReader reader = (MessageReader)readerAttr.get();
        if (reader == null) {
            reader = this.messageFormat.reader(this.serializationService.serializationRegistry(), this.binaryStreamVersion);
            readerAttr.set((Object)reader);
        }
        Attribute deserializerAttr = ctx.channel().attr(DESERIALIZER_KEY);
        Attribute groupTypeAttr = ctx.channel().attr(GROUP_TYPE_KEY);
        reader.setBuffer(buffer);
        while (buffer.hasRemaining()) {
            int initialNioBufferPosition = buffer.position();
            MessageDeserializer deserializer = (MessageDeserializer)deserializerAttr.get();
            try {
                if (deserializer == null) {
                    Short groupType = (Short)groupTypeAttr.get();
                    if (groupType == null) {
                        groupType = reader.readHeaderShort();
                        if (!reader.isLastRead()) {
                            InboundDecoder.fixNettyBufferReaderIndex(in, buffer, initialNioBufferPosition);
                            break;
                        }
                    }
                    short messageType = reader.readHeaderShort();
                    if (!reader.isLastRead()) {
                        groupTypeAttr.set((Object)groupType);
                        InboundDecoder.fixNettyBufferReaderIndex(in, buffer, initialNioBufferPosition);
                        break;
                    }
                    deserializer = this.serializationService.createMessageDeserializer(groupType, messageType);
                    groupTypeAttr.set(null);
                }
                boolean finished = false;
                if (deserializer != null && buffer.hasRemaining()) {
                    reader.setCurrentReadClass(deserializer.klass());
                    finished = deserializer.readMessage(reader);
                }
                int readBytes = InboundDecoder.fixNettyBufferReaderIndex(in, buffer, initialNioBufferPosition);
                if (finished) {
                    reader.reset();
                    deserializerAttr.set(null);
                    NetworkMessage message = deserializer.getMessage();
                    if (message instanceof ClassDescriptorListMessage) {
                        this.onClassDescriptorMessage((ClassDescriptorListMessage)message);
                    } else {
                        out.add(message);
                    }
                } else {
                    deserializerAttr.set((Object)deserializer);
                }
                if (readBytes != 0) continue;
                break;
            }
            catch (Throwable e) {
                LOG.debug("Failed to read message [deserializer={}, buf={}, reader={}, reason={}]", e, new Object[]{deserializer, buffer, reader, e.getMessage()});
                throw e;
            }
        }
    }

    static int fixNettyBufferReaderIndex(ByteBuf in, ByteBuffer buffer, int initialNioBufferPosition) {
        int readBytes = buffer.position() - initialNioBufferPosition;
        in.readerIndex(in.readerIndex() + readBytes);
        return readBytes;
    }

    private void onClassDescriptorMessage(ClassDescriptorListMessage msg) {
        this.serializationService.mergeDescriptors(msg.messages());
    }

    public void changeBinaryFormat(byte binaryStreamVersion, Channel channel) {
        this.binaryStreamVersion = binaryStreamVersion;
        InboundDecoder.clearReaderAttribute(channel);
    }

    public void changeBinaryFormat(byte binaryStreamVersion, MessageFormat messageFormat, Channel channel) {
        this.binaryStreamVersion = binaryStreamVersion;
        this.messageFormat = messageFormat;
        InboundDecoder.clearReaderAttribute(channel);
    }

    private static void clearReaderAttribute(Channel channel) {
        channel.attr(READER_KEY).set(null);
    }
}

