/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.network.recovery;

import java.io.IOException;
import java.util.BitSet;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.BooleanSupplier;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.network.ClusterIdSupplier;
import org.apache.ignite.internal.network.InternalClusterNode;
import org.apache.ignite.internal.network.NetworkMessage;
import org.apache.ignite.internal.network.NetworkMessagesFactory;
import org.apache.ignite.internal.network.OutNetworkObject;
import org.apache.ignite.internal.network.TopologyService;
import org.apache.ignite.internal.network.handshake.HandshakeEventLoopSwitcher;
import org.apache.ignite.internal.network.handshake.HelloMessage;
import org.apache.ignite.internal.network.handshake.HelloMessageSender;
import org.apache.ignite.internal.network.handshake.UnsupportedProtocolException;
import org.apache.ignite.internal.network.netty.ChannelCreationListener;
import org.apache.ignite.internal.network.netty.NettyUtils;
import org.apache.ignite.internal.network.netty.PipelineUtils;
import org.apache.ignite.internal.network.netty.ProtocolSniffer;
import org.apache.ignite.internal.network.recovery.ChannelNegotiation;
import org.apache.ignite.internal.network.recovery.HandshakeManagerUtils;
import org.apache.ignite.internal.network.recovery.HandshakeStartResponseMessageV2Adapter;
import org.apache.ignite.internal.network.recovery.RecoveryAcceptorHandshakeManager;
import org.apache.ignite.internal.network.recovery.RecoveryDescriptorProvider;
import org.apache.ignite.internal.network.recovery.StaleIdDetector;
import org.apache.ignite.internal.network.recovery.message.HandshakeStartResponseMessageV2;
import org.apache.ignite.internal.network.recovery.message.ProbeMessage;
import org.apache.ignite.internal.version.IgniteProductVersionSource;

public class RecoveryAcceptorHandshakeManagerV2
extends RecoveryAcceptorHandshakeManager {
    private static final IgniteLogger LOG = Loggers.forClass(RecoveryAcceptorHandshakeManagerV2.class);
    private static final NetworkMessagesFactory MESSAGE_FACTORY = new NetworkMessagesFactory();
    private int negotiatedHandshakeProtocolVersion;

    public RecoveryAcceptorHandshakeManagerV2(InternalClusterNode localNode, NetworkMessagesFactory messageFactory, RecoveryDescriptorProvider recoveryDescriptorProvider, HandshakeEventLoopSwitcher handshakeEventLoopSwitcher, StaleIdDetector staleIdDetector, ClusterIdSupplier clusterIdSupplier, ChannelCreationListener channelCreationListener, BooleanSupplier stopping, IgniteProductVersionSource productVersionSource, TopologyService topologyService) {
        super(localNode, messageFactory, recoveryDescriptorProvider, handshakeEventLoopSwitcher, staleIdDetector, clusterIdSupplier, channelCreationListener, stopping, productVersionSource, topologyService);
    }

    @Override
    public boolean supportsNewProtocol() {
        return true;
    }

    @Override
    public void onConnectionOpen() {
    }

    @Override
    protected void onProbeMessage(ProbeMessage message) {
        if (message.probe() == 0) {
            ProtocolSniffer.setDetectedNewProtocol(this.ctx, false);
            this.negotiatedHandshakeProtocolVersion = 1;
            this.sendHandshakeStartMessage();
        } else if (message.probe() == 1) {
            ProtocolSniffer.setDetectedNewProtocol(this.ctx, true);
            PipelineUtils.addHelloMessageDecoder(this.ctx.pipeline());
            ProbeMessage probe = MESSAGE_FACTORY.probeMessage().probe((byte)1).build();
            NettyUtils.toCompletableFuture(this.channel.writeAndFlush((Object)new OutNetworkObject(probe, List.of()))).whenComplete((res, ex) -> {
                if (ex != null) {
                    if (ex instanceof IOException) {
                        LOG.debug("Could not send a probe message via {}", ex, new Object[]{this.channel});
                    } else {
                        LOG.error("Could not send a probe message via {}", ex, new Object[]{this.channel});
                    }
                }
            });
        } else {
            throw new UnsupportedProtocolException("Unsupported protocol, probe message: " + message);
        }
    }

    @Override
    public void onHelloMessage(HelloMessage initiatorHello) {
        ((CompletableFuture)new HelloMessageSender(this.productVersionSource()).sendHelloMessage(this.ctx).thenRun(() -> {
            this.negotiatedHandshakeProtocolVersion = ChannelNegotiation.commonHandshakeProtocolVersion((byte)2, initiatorHello.handshakeProtocolVersion());
            HandshakeManagerUtils.switchToNegotiatedBinaryFormat(initiatorHello, this.ctx, this.productVersionSource());
            this.sendHandshakeStartMessage();
        })).whenComplete((res, ex) -> {
            if (ex != null) {
                if (ex instanceof IOException) {
                    LOG.debug("Could not send a handshake start message via {}", ex, new Object[]{this.channel});
                } else {
                    LOG.info("Could not send a handshake start message via {}", ex, new Object[]{this.channel});
                }
            }
        });
    }

    @Override
    protected NetworkMessage createHandshakeStartMessage() {
        assert (this.negotiatedHandshakeProtocolVersion > 0) : this.negotiatedHandshakeProtocolVersion;
        if (this.negotiatedHandshakeProtocolVersion == 1) {
            return super.createHandshakeStartMessage();
        }
        return this.messageFactory.handshakeStartMessageV2().acceptorNode(HandshakeManagerUtils.clusterNodeToMessage(this.localNode)).acceptorClusterId(this.clusterIdSupplier.clusterId()).productName(this.productVersionSource().productName()).featureSet(new BitSet()).build();
    }

    @Override
    public void onMessage(NetworkMessage message) {
        if (message instanceof HandshakeStartResponseMessageV2) {
            this.onHandshakeStartResponseMessage(new HandshakeStartResponseMessageV2Adapter((HandshakeStartResponseMessageV2)message));
            return;
        }
        super.onMessage(message);
    }
}

