/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.network.ru;

import org.apache.ignite.internal.network.ru.RollingUpgradeMessageWriter;
import org.apache.ignite.internal.network.serialization.MessageSerializationRegistry;

public class CompatibilityRollingUpgradeMessageWriter
extends RollingUpgradeMessageWriter {
    private static final int NO_OVERRIDE = -1;

    public CompatibilityRollingUpgradeMessageWriter(MessageSerializationRegistry serializationRegistry, byte protoVer) {
        super(serializationRegistry, protoVer);
    }

    @Override
    public boolean writeHeader(short groupType, short messageType, byte fieldCnt) {
        byte fieldCntToWrite = CompatibilityRollingUpgradeMessageWriter.adjustFieldCountToSend(groupType, messageType, fieldCnt);
        return super.writeHeader(groupType, messageType, fieldCntToWrite);
    }

    private static byte adjustFieldCountToSend(short groupType, short messageType, byte fieldCnt) {
        byte override = CompatibilityRollingUpgradeMessageWriter.fieldCountOverride(groupType, messageType);
        if (override != -1) {
            return override;
        }
        return fieldCnt;
    }

    private static byte fieldCountOverride(short groupType, short messageType) {
        if (groupType == 9) {
            switch (messageType) {
                case 0: {
                    return 12;
                }
                case 1: {
                    return 13;
                }
                case 2: {
                    return 13;
                }
                case 3: {
                    return 17;
                }
                case 19: {
                    return 12;
                }
                case 20: {
                    return 12;
                }
                case 16379: {
                    return 14;
                }
            }
            return -1;
        }
        if (groupType == 3 && messageType == 4001) {
            return 2;
        }
        return -1;
    }

    @Override
    protected boolean skipFieldWrite(String name) {
        RollingUpgradeMessageWriter.StateItem stateItem = (RollingUpgradeMessageWriter.StateItem)this.state.item();
        return stateItem.notVersionZero() && CompatibilityRollingUpgradeMessageWriter.shouldOnlySendVersion0Fields(stateItem.groupType, stateItem.messageType);
    }

    private static boolean shouldOnlySendVersion0Fields(short groupType, short messageType) {
        return CompatibilityRollingUpgradeMessageWriter.fieldCountOverride(groupType, messageType) != -1;
    }

    private static class PartitionReplicationGroupCompatibility {
        private static final short GROUP = 9;
        private static final short RW_SINGLE_ROW_REPLICA_REQUEST = 0;
        private static final short RW_MULTI_ROW_REPLICA_REQUEST = 1;
        private static final short RW_DUAL_ROW_REPLICA_REQUEST = 2;
        private static final short RW_SCAN_RETRIEVE_BATCH_REPLICA_REQUEST = 3;
        private static final short RW_SINGLE_ROW_PK_REPLICA_REQUEST = 19;
        private static final short RW_MULTI_ROW_PK_REPLICA_REQUEST = 20;
        private static final short DCR_WRITE_MULTI_ROW_REPLICA_REQUEST = 16379;

        private PartitionReplicationGroupCompatibility() {
        }
    }

    private static class RaftGroupCompatibility {
        private static final short GROUP = 3;
        private static final short WRITE_ACTION_REQUEST = 4001;

        private RaftGroupCompatibility() {
        }
    }
}

