/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.network.recovery.message;

import java.util.Objects;
import org.apache.ignite.internal.network.recovery.message.ProbeMessage;
import org.apache.ignite.internal.network.recovery.message.ProbeMessageBuilder;
import org.apache.ignite.internal.network.recovery.message.ProbeMessageSerializer;
import org.apache.ignite.internal.network.serialization.MessageSerializer;
import org.apache.ignite.internal.tostring.IgniteToStringInclude;
import org.apache.ignite.internal.tostring.S;

public class ProbeMessageImpl
implements ProbeMessage,
Cloneable {
    public static final short GROUP_TYPE = 1;
    public static final short TYPE = 12;
    @IgniteToStringInclude
    private final byte probe;

    private ProbeMessageImpl(byte probe) {
        this.probe = probe;
    }

    @Override
    public byte probe() {
        return this.probe;
    }

    public MessageSerializer serializer() {
        return ProbeMessageSerializer.INSTANCE;
    }

    public short groupType() {
        return 1;
    }

    public String toString() {
        return S.toString(ProbeMessageImpl.class, (Object)this);
    }

    public short messageType() {
        return 12;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        ProbeMessageImpl otherMessage = (ProbeMessageImpl)other;
        return this.probe == otherMessage.probe;
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.probe);
        return result;
    }

    public ProbeMessageImpl clone() {
        try {
            return (ProbeMessageImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static ProbeMessageBuilder builder() {
        return new Builder();
    }

    private static class Builder
    implements ProbeMessageBuilder {
        private byte probe;

        private Builder() {
        }

        @Override
        public ProbeMessageBuilder probe(byte probe) {
            this.probe = probe;
            return this;
        }

        @Override
        public byte probe() {
            return this.probe;
        }

        @Override
        public ProbeMessage build() {
            return new ProbeMessageImpl(this.probe);
        }

        @Override
        public ProbeMessage buildDeserialized() {
            return new ProbeMessageImpl(this.probe);
        }
    }
}

