/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.network.message;

import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Objects;
import org.apache.ignite.internal.network.NetworkMessage;
import org.apache.ignite.internal.network.message.InvokeRequest;
import org.apache.ignite.internal.network.message.InvokeRequestBuilder;
import org.apache.ignite.internal.network.message.InvokeRequestSerializer;
import org.apache.ignite.internal.network.serialization.MessageSerializer;
import org.apache.ignite.internal.network.serialization.marshal.UserObjectMarshaller;
import org.apache.ignite.internal.tostring.IgniteToStringInclude;
import org.apache.ignite.internal.tostring.S;

public class InvokeRequestImpl
implements InvokeRequest,
Cloneable {
    public static final short GROUP_TYPE = 1;
    public static final short TYPE = 0;
    @IgniteToStringInclude
    private final long correlationId;
    @IgniteToStringInclude
    private final NetworkMessage message;

    private InvokeRequestImpl(long correlationId, NetworkMessage message) {
        this.correlationId = correlationId;
        this.message = message;
    }

    @Override
    public long correlationId() {
        return this.correlationId;
    }

    @Override
    public NetworkMessage message() {
        return this.message;
    }

    public MessageSerializer serializer() {
        return InvokeRequestSerializer.INSTANCE;
    }

    public short groupType() {
        return 1;
    }

    public String toString() {
        return S.toString(InvokeRequestImpl.class, (Object)this);
    }

    public short messageType() {
        return 0;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        InvokeRequestImpl otherMessage = (InvokeRequestImpl)other;
        return Objects.equals(this.message, otherMessage.message) && this.correlationId == otherMessage.correlationId;
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.correlationId, this.message);
        return result;
    }

    public InvokeRequestImpl clone() {
        try {
            return (InvokeRequestImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static InvokeRequestBuilder builder() {
        return new Builder();
    }

    public void prepareMarshal(IntSet usedDescriptors, Object marshallerObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        if (this.message != null) {
            this.message.prepareMarshal(usedDescriptors, (Object)marshaller);
        }
    }

    public void unmarshal(Object marshallerObj, Object descriptorsObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        if (this.message != null) {
            this.message.unmarshal((Object)marshaller, descriptorsObj);
        }
    }

    private static class Builder
    implements InvokeRequestBuilder {
        private long correlationId;
        private NetworkMessage message;

        private Builder() {
        }

        @Override
        public InvokeRequestBuilder correlationId(long correlationId) {
            this.correlationId = correlationId;
            return this;
        }

        @Override
        public InvokeRequestBuilder message(NetworkMessage message) {
            Objects.requireNonNull(message, "message is not marked @Nullable");
            this.message = message;
            return this;
        }

        @Override
        public long correlationId() {
            return this.correlationId;
        }

        @Override
        public NetworkMessage message() {
            return this.message;
        }

        @Override
        public InvokeRequest build() {
            return new InvokeRequestImpl(this.correlationId, Objects.requireNonNull(this.message, "message is not marked @Nullable"));
        }

        @Override
        public InvokeRequest buildDeserialized() {
            return new InvokeRequestImpl(this.correlationId, this.message);
        }
    }
}

