/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.network.message;

import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Collection;
import java.util.Objects;
import org.apache.ignite.internal.network.message.ClassDescriptorMessage;
import org.apache.ignite.internal.network.message.ClassDescriptorMessageBuilder;
import org.apache.ignite.internal.network.message.ClassDescriptorMessageSerializer;
import org.apache.ignite.internal.network.message.FieldDescriptorMessage;
import org.apache.ignite.internal.network.serialization.MessageSerializer;
import org.apache.ignite.internal.network.serialization.marshal.UserObjectMarshaller;
import org.apache.ignite.internal.tostring.IgniteToStringInclude;
import org.apache.ignite.internal.tostring.S;

public class ClassDescriptorMessageImpl
implements ClassDescriptorMessage,
Cloneable {
    public static final short GROUP_TYPE = 1;
    public static final short TYPE = 8;
    @IgniteToStringInclude
    private final byte attributes;
    @IgniteToStringInclude
    private final String className;
    @IgniteToStringInclude
    private final int componentTypeDescriptorId;
    @IgniteToStringInclude
    private final String componentTypeName;
    @IgniteToStringInclude
    private final int descriptorId;
    @IgniteToStringInclude
    private final Collection<FieldDescriptorMessage> fields;
    @IgniteToStringInclude
    private final byte serializationFlags;
    @IgniteToStringInclude
    private final byte serializationType;
    @IgniteToStringInclude
    private final int superClassDescriptorId;
    @IgniteToStringInclude
    private final String superClassName;

    private ClassDescriptorMessageImpl(byte attributes, String className, int componentTypeDescriptorId, String componentTypeName, int descriptorId, Collection<FieldDescriptorMessage> fields, byte serializationFlags, byte serializationType, int superClassDescriptorId, String superClassName) {
        this.attributes = attributes;
        this.className = className;
        this.componentTypeDescriptorId = componentTypeDescriptorId;
        this.componentTypeName = componentTypeName;
        this.descriptorId = descriptorId;
        this.fields = fields;
        this.serializationFlags = serializationFlags;
        this.serializationType = serializationType;
        this.superClassDescriptorId = superClassDescriptorId;
        this.superClassName = superClassName;
    }

    @Override
    public byte attributes() {
        return this.attributes;
    }

    @Override
    public String className() {
        return this.className;
    }

    @Override
    public int componentTypeDescriptorId() {
        return this.componentTypeDescriptorId;
    }

    @Override
    public String componentTypeName() {
        return this.componentTypeName;
    }

    @Override
    public int descriptorId() {
        return this.descriptorId;
    }

    @Override
    public Collection<FieldDescriptorMessage> fields() {
        return this.fields;
    }

    @Override
    public byte serializationFlags() {
        return this.serializationFlags;
    }

    @Override
    public byte serializationType() {
        return this.serializationType;
    }

    @Override
    public int superClassDescriptorId() {
        return this.superClassDescriptorId;
    }

    @Override
    public String superClassName() {
        return this.superClassName;
    }

    public MessageSerializer serializer() {
        return ClassDescriptorMessageSerializer.INSTANCE;
    }

    public short groupType() {
        return 1;
    }

    public String toString() {
        return S.toString(ClassDescriptorMessageImpl.class, (Object)this);
    }

    public short messageType() {
        return 8;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        ClassDescriptorMessageImpl otherMessage = (ClassDescriptorMessageImpl)other;
        return Objects.equals(this.className, otherMessage.className) && Objects.equals(this.componentTypeName, otherMessage.componentTypeName) && Objects.equals(this.fields, otherMessage.fields) && Objects.equals(this.superClassName, otherMessage.superClassName) && this.attributes == otherMessage.attributes && this.componentTypeDescriptorId == otherMessage.componentTypeDescriptorId && this.descriptorId == otherMessage.descriptorId && this.serializationFlags == otherMessage.serializationFlags && this.serializationType == otherMessage.serializationType && this.superClassDescriptorId == otherMessage.superClassDescriptorId;
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.attributes, this.componentTypeDescriptorId, this.descriptorId, this.serializationFlags, this.serializationType, this.superClassDescriptorId, this.className, this.componentTypeName, this.fields, this.superClassName);
        return result;
    }

    public ClassDescriptorMessageImpl clone() {
        try {
            return (ClassDescriptorMessageImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static ClassDescriptorMessageBuilder builder() {
        return new Builder();
    }

    public void prepareMarshal(IntSet usedDescriptors, Object marshallerObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        if (this.fields != null) {
            for (FieldDescriptorMessage obj : this.fields) {
                if (obj == null) continue;
                obj.prepareMarshal(usedDescriptors, marshaller);
            }
        }
    }

    public void unmarshal(Object marshallerObj, Object descriptorsObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        if (this.fields != null) {
            for (FieldDescriptorMessage obj : this.fields) {
                if (obj == null) continue;
                obj.unmarshal(marshaller, descriptorsObj);
            }
        }
    }

    private static class Builder
    implements ClassDescriptorMessageBuilder {
        private byte attributes;
        private String className;
        private int componentTypeDescriptorId;
        private String componentTypeName;
        private int descriptorId;
        private Collection<FieldDescriptorMessage> fields;
        private byte serializationFlags;
        private byte serializationType;
        private int superClassDescriptorId;
        private String superClassName;

        private Builder() {
        }

        @Override
        public ClassDescriptorMessageBuilder attributes(byte attributes) {
            this.attributes = attributes;
            return this;
        }

        @Override
        public ClassDescriptorMessageBuilder className(String className) {
            Objects.requireNonNull(className, "className is not marked @Nullable");
            this.className = className;
            return this;
        }

        @Override
        public ClassDescriptorMessageBuilder componentTypeDescriptorId(int componentTypeDescriptorId) {
            this.componentTypeDescriptorId = componentTypeDescriptorId;
            return this;
        }

        @Override
        public ClassDescriptorMessageBuilder componentTypeName(String componentTypeName) {
            this.componentTypeName = componentTypeName;
            return this;
        }

        @Override
        public ClassDescriptorMessageBuilder descriptorId(int descriptorId) {
            this.descriptorId = descriptorId;
            return this;
        }

        @Override
        public ClassDescriptorMessageBuilder fields(Collection<FieldDescriptorMessage> fields) {
            Objects.requireNonNull(fields, "fields is not marked @Nullable");
            this.fields = fields;
            return this;
        }

        @Override
        public ClassDescriptorMessageBuilder serializationFlags(byte serializationFlags) {
            this.serializationFlags = serializationFlags;
            return this;
        }

        @Override
        public ClassDescriptorMessageBuilder serializationType(byte serializationType) {
            this.serializationType = serializationType;
            return this;
        }

        @Override
        public ClassDescriptorMessageBuilder superClassDescriptorId(int superClassDescriptorId) {
            this.superClassDescriptorId = superClassDescriptorId;
            return this;
        }

        @Override
        public ClassDescriptorMessageBuilder superClassName(String superClassName) {
            this.superClassName = superClassName;
            return this;
        }

        @Override
        public byte attributes() {
            return this.attributes;
        }

        @Override
        public String className() {
            return this.className;
        }

        @Override
        public int componentTypeDescriptorId() {
            return this.componentTypeDescriptorId;
        }

        @Override
        public String componentTypeName() {
            return this.componentTypeName;
        }

        @Override
        public int descriptorId() {
            return this.descriptorId;
        }

        @Override
        public Collection<FieldDescriptorMessage> fields() {
            return this.fields;
        }

        @Override
        public byte serializationFlags() {
            return this.serializationFlags;
        }

        @Override
        public byte serializationType() {
            return this.serializationType;
        }

        @Override
        public int superClassDescriptorId() {
            return this.superClassDescriptorId;
        }

        @Override
        public String superClassName() {
            return this.superClassName;
        }

        @Override
        public ClassDescriptorMessage build() {
            return new ClassDescriptorMessageImpl(this.attributes, Objects.requireNonNull(this.className, "className is not marked @Nullable"), this.componentTypeDescriptorId, this.componentTypeName, this.descriptorId, Objects.requireNonNull(this.fields, "fields is not marked @Nullable"), this.serializationFlags, this.serializationType, this.superClassDescriptorId, this.superClassName);
        }

        @Override
        public ClassDescriptorMessage buildDeserialized() {
            return new ClassDescriptorMessageImpl(this.attributes, this.className, this.componentTypeDescriptorId, this.componentTypeName, this.descriptorId, this.fields, this.serializationFlags, this.serializationType, this.superClassDescriptorId, this.superClassName);
        }
    }
}

