/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.network.configuration;

import io.netty.buffer.ByteBufAllocator;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.net.ssl.SSLException;
import org.apache.ignite.configuration.validation.ValidationContext;
import org.apache.ignite.configuration.validation.ValidationIssue;
import org.apache.ignite.configuration.validation.Validator;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.network.configuration.AbstractSslView;
import org.apache.ignite.internal.network.configuration.KeyStoreView;
import org.apache.ignite.internal.network.configuration.SslConfigurationValidator;
import org.apache.ignite.internal.util.StringUtils;

public class SslConfigurationValidatorImpl
implements Validator<SslConfigurationValidator, AbstractSslView> {
    public static final SslConfigurationValidatorImpl INSTANCE = new SslConfigurationValidatorImpl();
    private static final IgniteLogger LOG = Loggers.forClass(SslConfigurationValidatorImpl.class);

    public void validate(SslConfigurationValidator annotation, ValidationContext<AbstractSslView> ctx) {
        AbstractSslView ssl = (AbstractSslView)ctx.getNewValue();
        if (ssl.enabled()) {
            SslConfigurationValidatorImpl.validateKeyStore(ctx, ".keyStore", "Key store", ssl.keyStore());
            try {
                ClientAuth clientAuth = ClientAuth.valueOf((String)ssl.clientAuth().toUpperCase());
                if (clientAuth != ClientAuth.NONE) {
                    SslConfigurationValidatorImpl.validateKeyStore(ctx, ".trustStore", "Trust store", ssl.trustStore());
                }
            }
            catch (IllegalArgumentException e) {
                ctx.addIssue(new ValidationIssue(ctx.currentKey(), "Incorrect client auth parameter " + ssl.clientAuth()));
            }
            if (!ssl.ciphers().isBlank()) {
                SslConfigurationValidatorImpl.validateCiphers(ctx, ssl);
            }
        }
    }

    private static void validateKeyStore(ValidationContext<AbstractSslView> ctx, String keyName, String type, KeyStoreView keyStore) {
        String keyStorePath = keyStore.path();
        if (StringUtils.nullOrBlank((String)keyStorePath) && StringUtils.nullOrBlank((String)keyStore.password())) {
            return;
        }
        if (StringUtils.nullOrBlank((String)keyStore.type())) {
            ctx.addIssue(new ValidationIssue(ctx.currentKey() + keyName, type + " type must not be blank"));
        }
        if (StringUtils.nullOrBlank((String)keyStorePath)) {
            ctx.addIssue(new ValidationIssue(ctx.currentKey() + keyName, type + " path must not be blank"));
        } else {
            try {
                if (!Files.exists(Path.of(keyStorePath, new String[0]), new LinkOption[0])) {
                    ctx.addIssue(new ValidationIssue(ctx.currentKey() + keyName, type + " file doesn't exist at " + keyStorePath));
                }
            }
            catch (InvalidPathException e) {
                ctx.addIssue(new ValidationIssue(ctx.currentKey() + keyName, type + " file path is incorrect: " + keyStorePath));
            }
        }
    }

    private static void validateCiphers(ValidationContext<AbstractSslView> ctx, AbstractSslView ssl) {
        try {
            SslContext context = SslContextBuilder.forClient().build();
            Set supported = Arrays.stream(context.newEngine(ByteBufAllocator.DEFAULT).getSupportedCipherSuites()).filter(Objects::nonNull).collect(Collectors.toSet());
            Set ciphers = Arrays.stream(ssl.ciphers().split(",")).map(String::strip).collect(Collectors.toSet());
            boolean haveSupported = ciphers.removeAll(supported);
            if (!ciphers.isEmpty()) {
                if (!haveSupported) {
                    ctx.addIssue(new ValidationIssue(ctx.currentKey(), "None of the configured cipher suites are supported: " + ciphers));
                }
                LOG.info("Some of the configured cipher suites are unsupported: {}", new Object[]{ciphers});
            }
        }
        catch (SSLException e) {
            ctx.addIssue(new ValidationIssue(ctx.currentKey(), "Can't create SSL engine"));
            LOG.warn("Can't create SSL engine", (Throwable)e);
        }
    }
}

