/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.network.recovery.message;

import java.util.BitSet;
import java.util.UUID;
import org.apache.ignite.internal.network.NetworkMessagesFactory;
import org.apache.ignite.internal.network.NetworkMessagesTypeInfos;
import org.apache.ignite.internal.network.message.ClusterNodeMessage;
import org.apache.ignite.internal.network.recovery.message.HandshakeStartMessageV2;
import org.apache.ignite.internal.network.recovery.message.HandshakeStartMessageV2Builder;
import org.apache.ignite.internal.network.serialization.MessageDeserializer;
import org.apache.ignite.internal.network.serialization.MessageMappingException;
import org.apache.ignite.internal.network.serialization.MessageReader;

class HandshakeStartMessageV2Deserializer
implements MessageDeserializer<HandshakeStartMessageV2> {
    private final HandshakeStartMessageV2Builder msg;

    HandshakeStartMessageV2Deserializer(NetworkMessagesFactory messageFactory) {
        this.msg = messageFactory.handshakeStartMessageV2();
    }

    public Class<HandshakeStartMessageV2> klass() {
        return HandshakeStartMessageV2.class;
    }

    public HandshakeStartMessageV2 getMessage() {
        return this.msg.buildDeserialized();
    }

    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        reader.setMessageTypeInfo(NetworkMessagesTypeInfos.handshakeStartMessageV2());
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                Object tmp = reader.readUuid("acceptorClusterId");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.acceptorClusterId((UUID)tmp);
                }
                reader.incrementState();
            }
            case 1: {
                Object tmp = (ClusterNodeMessage)reader.readMessage("acceptorNode");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.acceptorNode((ClusterNodeMessage)tmp);
                }
                reader.incrementState();
            }
            case 2: {
                Object tmp = reader.readBitSet("featureSet");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.featureSet((BitSet)tmp);
                }
                reader.incrementState();
            }
            case 3: {
                Object tmp = reader.readString("productName");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.productName((String)tmp);
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(HandshakeStartMessageV2.class);
    }
}

