/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.network.recovery.message;

import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.BitSet;
import java.util.Objects;
import java.util.UUID;
import org.apache.ignite.internal.network.message.ClusterNodeMessage;
import org.apache.ignite.internal.network.recovery.message.HandshakeStartMessageV2;
import org.apache.ignite.internal.network.recovery.message.HandshakeStartMessageV2Builder;
import org.apache.ignite.internal.network.recovery.message.HandshakeStartMessageV2Serializer;
import org.apache.ignite.internal.network.serialization.MessageSerializer;
import org.apache.ignite.internal.network.serialization.marshal.UserObjectMarshaller;
import org.apache.ignite.internal.tostring.IgniteToStringInclude;
import org.apache.ignite.internal.tostring.S;

public class HandshakeStartMessageV2Impl
implements HandshakeStartMessageV2,
Cloneable {
    public static final short GROUP_TYPE = 1;
    public static final short TYPE = 51;
    @IgniteToStringInclude
    private final UUID acceptorClusterId;
    @IgniteToStringInclude
    private final ClusterNodeMessage acceptorNode;
    @IgniteToStringInclude
    private final BitSet featureSet;
    @IgniteToStringInclude
    private final String productName;

    private HandshakeStartMessageV2Impl(UUID acceptorClusterId, ClusterNodeMessage acceptorNode, BitSet featureSet, String productName) {
        this.acceptorClusterId = acceptorClusterId;
        this.acceptorNode = acceptorNode;
        this.featureSet = featureSet;
        this.productName = productName;
    }

    @Override
    public UUID acceptorClusterId() {
        return this.acceptorClusterId;
    }

    @Override
    public ClusterNodeMessage acceptorNode() {
        return this.acceptorNode;
    }

    @Override
    public BitSet featureSet() {
        return this.featureSet;
    }

    @Override
    public String productName() {
        return this.productName;
    }

    public MessageSerializer serializer() {
        return HandshakeStartMessageV2Serializer.INSTANCE;
    }

    public short groupType() {
        return 1;
    }

    public String toString() {
        return S.toString(HandshakeStartMessageV2Impl.class, (Object)this);
    }

    public short messageType() {
        return 51;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        HandshakeStartMessageV2Impl otherMessage = (HandshakeStartMessageV2Impl)other;
        return Objects.equals(this.acceptorClusterId, otherMessage.acceptorClusterId) && Objects.equals(this.acceptorNode, otherMessage.acceptorNode) && Objects.equals(this.featureSet, otherMessage.featureSet) && Objects.equals(this.productName, otherMessage.productName);
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.acceptorClusterId, this.acceptorNode, this.featureSet, this.productName);
        return result;
    }

    public HandshakeStartMessageV2Impl clone() {
        try {
            return (HandshakeStartMessageV2Impl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static HandshakeStartMessageV2Builder builder() {
        return new Builder();
    }

    public void prepareMarshal(IntSet usedDescriptors, Object marshallerObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        if (this.acceptorNode != null) {
            this.acceptorNode.prepareMarshal(usedDescriptors, marshaller);
        }
    }

    public void unmarshal(Object marshallerObj, Object descriptorsObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        if (this.acceptorNode != null) {
            this.acceptorNode.unmarshal(marshaller, descriptorsObj);
        }
    }

    private static class Builder
    implements HandshakeStartMessageV2Builder {
        private UUID acceptorClusterId;
        private ClusterNodeMessage acceptorNode;
        private BitSet featureSet;
        private String productName;

        private Builder() {
        }

        @Override
        public HandshakeStartMessageV2Builder acceptorClusterId(UUID acceptorClusterId) {
            this.acceptorClusterId = acceptorClusterId;
            return this;
        }

        @Override
        public HandshakeStartMessageV2Builder acceptorNode(ClusterNodeMessage acceptorNode) {
            Objects.requireNonNull(acceptorNode, "acceptorNode is not marked @Nullable");
            this.acceptorNode = acceptorNode;
            return this;
        }

        @Override
        public HandshakeStartMessageV2Builder featureSet(BitSet featureSet) {
            Objects.requireNonNull(featureSet, "featureSet is not marked @Nullable");
            this.featureSet = featureSet;
            return this;
        }

        @Override
        public HandshakeStartMessageV2Builder productName(String productName) {
            Objects.requireNonNull(productName, "productName is not marked @Nullable");
            this.productName = productName;
            return this;
        }

        @Override
        public UUID acceptorClusterId() {
            return this.acceptorClusterId;
        }

        @Override
        public ClusterNodeMessage acceptorNode() {
            return this.acceptorNode;
        }

        @Override
        public BitSet featureSet() {
            return this.featureSet;
        }

        @Override
        public String productName() {
            return this.productName;
        }

        @Override
        public HandshakeStartMessageV2 build() {
            return new HandshakeStartMessageV2Impl(this.acceptorClusterId, Objects.requireNonNull(this.acceptorNode, "acceptorNode is not marked @Nullable"), Objects.requireNonNull(this.featureSet, "featureSet is not marked @Nullable"), Objects.requireNonNull(this.productName, "productName is not marked @Nullable"));
        }

        @Override
        public HandshakeStartMessageV2 buildDeserialized() {
            return new HandshakeStartMessageV2Impl(this.acceptorClusterId, this.acceptorNode, this.featureSet, this.productName);
        }
    }
}

