/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.network.recovery;

import java.util.BitSet;
import java.util.function.BooleanSupplier;
import org.apache.ignite.internal.network.ClusterIdSupplier;
import org.apache.ignite.internal.network.InternalClusterNode;
import org.apache.ignite.internal.network.NetworkMessage;
import org.apache.ignite.internal.network.handshake.HandshakeEventLoopSwitcher;
import org.apache.ignite.internal.network.handshake.HelloMessage;
import org.apache.ignite.internal.network.netty.ChannelCreationListener;
import org.apache.ignite.internal.network.recovery.ChannelNegotiation;
import org.apache.ignite.internal.network.recovery.HandshakeManagerUtils;
import org.apache.ignite.internal.network.recovery.HandshakeStartMessageV2Adapter;
import org.apache.ignite.internal.network.recovery.RecoveryDescriptor;
import org.apache.ignite.internal.network.recovery.RecoveryDescriptorProvider;
import org.apache.ignite.internal.network.recovery.RecoveryInitiatorHandshakeManager;
import org.apache.ignite.internal.network.recovery.StaleIdDetector;
import org.apache.ignite.internal.network.recovery.message.HandshakeStartMessageV2;
import org.apache.ignite.internal.version.IgniteProductVersionSource;

public class RecoveryInitiatorHandshakeManagerV2
extends RecoveryInitiatorHandshakeManager {
    private int negotiatedHandshakeProtocolVersion = 1;

    public RecoveryInitiatorHandshakeManagerV2(InternalClusterNode localNode, short connectionId, RecoveryDescriptorProvider recoveryDescriptorProvider, HandshakeEventLoopSwitcher handshakeEventLoopSwitcher, StaleIdDetector staleIdDetector, ClusterIdSupplier clusterIdSupplier, ChannelCreationListener channelCreationListener, BooleanSupplier stopping, IgniteProductVersionSource productVersionSource) {
        super(localNode, connectionId, recoveryDescriptorProvider, handshakeEventLoopSwitcher, staleIdDetector, clusterIdSupplier, channelCreationListener, stopping, productVersionSource);
    }

    @Override
    public boolean supportsNewProtocol() {
        return true;
    }

    @Override
    protected byte probePayload() {
        return 1;
    }

    @Override
    public void onHelloMessage(HelloMessage acceptorHello) {
        this.negotiatedHandshakeProtocolVersion = ChannelNegotiation.commonHandshakeProtocolVersion((byte)2, acceptorHello.handshakeProtocolVersion());
        HandshakeManagerUtils.switchToNegotiatedBinaryFormat(acceptorHello, this.ctx, this.productVersionSource());
    }

    @Override
    public void onMessage(NetworkMessage message) {
        if (message instanceof HandshakeStartMessageV2) {
            this.onHandshakeStartMessage(new HandshakeStartMessageV2Adapter((HandshakeStartMessageV2)message));
            return;
        }
        super.onMessage(message);
    }

    @Override
    protected NetworkMessage createHandshakeStartResponseMessage(RecoveryDescriptor descriptor) {
        if (this.negotiatedHandshakeProtocolVersion == 1) {
            return super.createHandshakeStartResponseMessage(descriptor);
        }
        return MESSAGE_FACTORY.handshakeStartResponseMessageV2().initiatorNode(HandshakeManagerUtils.clusterNodeToMessage(this.localNode)).receivedCount(descriptor.receivedCount()).connectionId(this.connectionId).featureSet(new BitSet()).build();
    }
}

