/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.network.netty;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.util.Attribute;
import io.netty.util.AttributeKey;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.ignite.internal.network.direct.stream.DirectByteBufferStream;
import org.apache.ignite.internal.network.direct.stream.DirectByteBufferStreamImplV1;
import org.apache.ignite.internal.network.handshake.HelloMessage;
import org.apache.ignite.internal.network.netty.InboundDecoder;
import org.apache.ignite.internal.network.serialization.BrokenSerializationRegistry;
import org.apache.ignite.internal.network.serialization.MessageSerializationRegistry;

public class HelloMessageDecoder
extends ByteToMessageDecoder {
    public static final String NAME = "hello-message-decoder";
    static final String STATE_KEY_NAME = "DECODER_STATE";
    private static final AttributeKey<State> STATE_KEY = AttributeKey.valueOf(HelloMessageDecoder.class, (String)"DECODER_STATE");
    static final AttributeKey<DirectByteBufferStream> STREAM_KEY = AttributeKey.valueOf(HelloMessageDecoder.class, (String)"STREAM");

    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        DirectByteBufferStream stream = HelloMessageDecoder.getOrCreateStream(ctx);
        ByteBuffer nioBuffer = in.nioBuffer();
        stream.setBuffer(nioBuffer);
        int positionBeforeRead = nioBuffer.position();
        State state = HelloMessageDecoder.getOrCreateState(ctx);
        switch (state.stage) {
            case 0: {
                state.handshakeProtocolVersion = stream.readByte();
                if (!stream.lastFinished()) {
                    InboundDecoder.fixNettyBufferReaderIndex(in, nioBuffer, positionBeforeRead);
                    break;
                }
                ++state.stage;
            }
            case 1: {
                state.remainingHelloMessageBytes = stream.readFixedInt();
                if (!stream.lastFinished()) {
                    InboundDecoder.fixNettyBufferReaderIndex(in, nioBuffer, positionBeforeRead);
                    break;
                }
                ++state.stage;
            }
            case 2: {
                int positionBeforeReadingBinaryStreamVersion = nioBuffer.position();
                state.binaryStreamVersion = stream.readByte();
                state.bytesConsumedOfRemainingBytes += nioBuffer.position() - positionBeforeReadingBinaryStreamVersion;
                if (!stream.lastFinished()) {
                    InboundDecoder.fixNettyBufferReaderIndex(in, nioBuffer, positionBeforeRead);
                    break;
                }
                ++state.stage;
            }
            case 3: {
                int positionBeforeReadingProductVersion = nioBuffer.position();
                state.productVersion = stream.readString();
                state.bytesConsumedOfRemainingBytes += nioBuffer.position() - positionBeforeReadingProductVersion;
                if (!stream.lastFinished()) {
                    InboundDecoder.fixNettyBufferReaderIndex(in, nioBuffer, positionBeforeRead);
                    break;
                }
                ++state.stage;
            }
            case 4: {
                int positionBeforeSkipping = nioBuffer.position();
                int bytesToSkip = Math.min(state.remainingHelloMessageBytes - state.bytesConsumedOfRemainingBytes, nioBuffer.remaining());
                nioBuffer.position(nioBuffer.position() + bytesToSkip);
                state.bytesConsumedOfRemainingBytes += nioBuffer.position() - positionBeforeSkipping;
                if (state.notAllRemainingMessageBytesConsumed()) {
                    InboundDecoder.fixNettyBufferReaderIndex(in, nioBuffer, positionBeforeRead);
                    break;
                }
                InboundDecoder.fixNettyBufferReaderIndex(in, nioBuffer, positionBeforeRead);
                ctx.pipeline().remove((ChannelHandler)this);
                ctx.channel().attr(STATE_KEY).set(null);
                ctx.channel().attr(STREAM_KEY).set(null);
                out.add(state.buildHelloMessage());
                break;
            }
            default: {
                throw new IllegalStateException("Should not be here");
            }
        }
    }

    private static DirectByteBufferStream getOrCreateStream(ChannelHandlerContext ctx) {
        Attribute streamAttr = ctx.channel().attr(STREAM_KEY);
        if (streamAttr.get() == null) {
            streamAttr.set((Object)new DirectByteBufferStreamImplV1((MessageSerializationRegistry)new BrokenSerializationRegistry()));
        }
        return (DirectByteBufferStream)streamAttr.get();
    }

    private static State getOrCreateState(ChannelHandlerContext ctx) {
        Attribute stateAttr = ctx.channel().attr(STATE_KEY);
        if (stateAttr.get() == null) {
            stateAttr.set((Object)new State());
        }
        return (State)stateAttr.get();
    }

    private static class State {
        private int stage = 0;
        private byte handshakeProtocolVersion;
        private byte binaryStreamVersion;
        private String productVersion;
        private int remainingHelloMessageBytes;
        private int bytesConsumedOfRemainingBytes = 0;

        private State() {
        }

        private boolean notAllRemainingMessageBytesConsumed() {
            return this.bytesConsumedOfRemainingBytes < this.remainingHelloMessageBytes;
        }

        private HelloMessage buildHelloMessage() {
            return new HelloMessage(this.handshakeProtocolVersion, this.binaryStreamVersion, this.productVersion);
        }
    }
}

