/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.network.netty;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.DecoderException;
import java.util.function.Consumer;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.network.InternalClusterNode;
import org.apache.ignite.internal.network.NetworkMessage;
import org.apache.ignite.internal.network.handshake.HandshakeException;
import org.apache.ignite.internal.network.handshake.HandshakeManager;
import org.apache.ignite.internal.network.handshake.HelloMessage;
import org.apache.ignite.internal.network.handshake.UnsupportedProtocolException;
import org.apache.ignite.internal.network.netty.InNetworkObject;
import org.apache.ignite.internal.network.netty.MessageHandler;
import org.apache.ignite.internal.network.serialization.PerSessionSerializationService;

public class HandshakeHandler
extends ChannelInboundHandlerAdapter {
    public static final String NAME = "handshake-handler";
    private static final IgniteLogger LOG = Loggers.forClass(HandshakeHandler.class);
    private final HandshakeManager manager;
    private final Consumer<InNetworkObject> messageListener;
    private final PerSessionSerializationService serializationService;

    public HandshakeHandler(HandshakeManager manager, Consumer<InNetworkObject> messageListener, PerSessionSerializationService serializationService) {
        this.manager = manager;
        this.messageListener = messageListener;
        this.serializationService = serializationService;
    }

    public void handlerAdded(ChannelHandlerContext ctx) {
        this.manager.onInit(ctx);
    }

    public void channelActive(ChannelHandlerContext ctx) {
        try {
            this.manager.onConnectionOpen();
        }
        catch (Throwable e) {
            LOG.error("Error in onConnectionOpen()", e);
            throw e;
        }
        this.manager.localHandshakeFuture().whenComplete((unused, throwable) -> {
            if (throwable != null) {
                if (HandshakeHandler.unexpectedException(throwable)) {
                    LOG.error("Error when performing handshake", throwable);
                } else {
                    LOG.debug("Error when performing handshake", throwable);
                }
                ctx.close();
            }
        });
        ctx.fireChannelActive();
    }

    private static boolean unexpectedException(Throwable ex) {
        return ex instanceof Error || ex instanceof DecoderException || ex instanceof NullPointerException || ex instanceof IllegalArgumentException || ex instanceof IllegalStateException || ex instanceof ClassCastException || ex instanceof UnsupportedOperationException || ex instanceof UnsupportedProtocolException;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        if (msg instanceof HelloMessage) {
            this.manager.onHelloMessage((HelloMessage)msg);
            return;
        }
        this.manager.onMessage((NetworkMessage)msg);
    }

    public void channelInactive(ChannelHandlerContext ctx) {
        this.manager.localHandshakeFuture().completeExceptionally(new HandshakeException("Channel has been closed before handshake has finished or handshake has failed"));
        ctx.fireChannelInactive();
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        this.manager.localHandshakeFuture().completeExceptionally(cause);
    }

    public MessageHandler createMessageHandler(InternalClusterNode remoteNode, short connectionIndex) {
        return new MessageHandler(this.messageListener, remoteNode, connectionIndex, this.serializationService);
    }
}

