/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.network.message;

import java.util.Collection;
import org.apache.ignite.internal.network.NetworkMessagesFactory;
import org.apache.ignite.internal.network.NetworkMessagesTypeInfos;
import org.apache.ignite.internal.network.message.ClassDescriptorListMessage;
import org.apache.ignite.internal.network.message.ClassDescriptorListMessageBuilder;
import org.apache.ignite.internal.network.serialization.MessageCollectionItemType;
import org.apache.ignite.internal.network.serialization.MessageDeserializer;
import org.apache.ignite.internal.network.serialization.MessageMappingException;
import org.apache.ignite.internal.network.serialization.MessageReader;

class ClassDescriptorListMessageDeserializer
implements MessageDeserializer<ClassDescriptorListMessage> {
    private final ClassDescriptorListMessageBuilder msg;

    ClassDescriptorListMessageDeserializer(NetworkMessagesFactory messageFactory) {
        this.msg = messageFactory.classDescriptorListMessage();
    }

    public Class<ClassDescriptorListMessage> klass() {
        return ClassDescriptorListMessage.class;
    }

    public ClassDescriptorListMessage getMessage() {
        return this.msg.buildDeserialized();
    }

    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        reader.setMessageTypeInfo(NetworkMessagesTypeInfos.classDescriptorListMessage());
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                Collection tmp = reader.readCollection("messages", MessageCollectionItemType.MSG);
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.messages(tmp);
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(ClassDescriptorListMessage.class);
    }
}

