/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.network.handshake;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelHandlerContext;
import java.nio.ByteBuffer;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite.internal.network.direct.stream.DirectByteBufferStreamImplV1;
import org.apache.ignite.internal.network.handshake.HelloMessage;
import org.apache.ignite.internal.network.netty.NettyUtils;
import org.apache.ignite.internal.network.serialization.BrokenSerializationRegistry;
import org.apache.ignite.internal.network.serialization.MessageSerializationRegistry;
import org.apache.ignite.internal.version.IgniteProductVersionSource;
import org.jetbrains.annotations.Nullable;

public class HelloMessageSender {
    private static final int ENOUGH_BYTES_FOR_HELLO_MESSAGE = 16384;
    private final IgniteProductVersionSource productVersionSource;

    public HelloMessageSender(IgniteProductVersionSource productVersionSource) {
        this.productVersionSource = productVersionSource;
    }

    public CompletableFuture<Void> sendHelloMessage(ChannelHandlerContext ctx) {
        HelloMessage helloMessage = new HelloMessage(2, 1, this.productVersionSource.productVersion().toString());
        ByteBufAllocator allocator = ctx.alloc();
        ByteBuf buf = HelloMessageSender.serializeHelloMessage(helloMessage, allocator);
        return NettyUtils.toCompletableFuture(ctx.channel().writeAndFlush((Object)buf));
    }

    private static ByteBuf bufferLargeEnoughForHelloMessage(ByteBufAllocator allocator) {
        return allocator.ioBuffer(16384);
    }

    private static ByteBuf serializeHelloMessage(HelloMessage helloMessage, ByteBufAllocator allocator) {
        return HelloMessageSender.serializeHelloMessage(helloMessage, allocator, null);
    }

    public static ByteBuf serializeHelloMessage(HelloMessage helloMessage, ByteBufAllocator allocator, @Nullable String extraString) {
        DirectByteBufferStreamImplV1 stream = new DirectByteBufferStreamImplV1((MessageSerializationRegistry)new BrokenSerializationRegistry());
        ByteBuf buf = HelloMessageSender.bufferLargeEnoughForHelloMessage(allocator);
        ByteBuffer nioBuffer = buf.nioBuffer(0, buf.capacity());
        int initialPosition = nioBuffer.position();
        stream.setBuffer(nioBuffer);
        stream.writeByte(helloMessage.handshakeProtocolVersion());
        int remainingMessageSizePos = nioBuffer.position();
        stream.writeFixedInt(0);
        int remainingMessagePos = nioBuffer.position();
        stream.writeByte(helloMessage.binaryStreamVersion());
        stream.writeString(helloMessage.productVersion());
        if (extraString != null) {
            stream.writeString(extraString);
        }
        assert (stream.lastFinished());
        int finalPos = nioBuffer.position();
        nioBuffer.position(remainingMessageSizePos);
        stream.writeFixedInt(finalPos - remainingMessagePos);
        nioBuffer.position(finalPos);
        buf.writerIndex(nioBuffer.position() - initialPosition);
        return buf;
    }
}

