/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.network.recovery.message;

import org.apache.ignite.internal.network.NetworkMessage;
import org.apache.ignite.internal.network.NetworkMessagesTypeInfos;
import org.apache.ignite.internal.network.recovery.message.HandshakeStartMessageV2;
import org.apache.ignite.internal.network.recovery.message.HandshakeStartMessageV2Impl;
import org.apache.ignite.internal.network.serialization.MessageMappingException;
import org.apache.ignite.internal.network.serialization.MessageSerializer;
import org.apache.ignite.internal.network.serialization.MessageWriter;

class HandshakeStartMessageV2Serializer
implements MessageSerializer<HandshakeStartMessageV2> {
    public static final HandshakeStartMessageV2Serializer INSTANCE = new HandshakeStartMessageV2Serializer();

    private HandshakeStartMessageV2Serializer() {
    }

    public boolean writeMessage(HandshakeStartMessageV2 msg, MessageWriter writer) throws MessageMappingException {
        HandshakeStartMessageV2Impl message = (HandshakeStartMessageV2Impl)msg;
        writer.setMessageTypeInfo(NetworkMessagesTypeInfos.handshakeStartMessageV2());
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(message.groupType(), message.messageType(), (byte)4)) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                boolean written = writer.writeUuid("acceptorClusterId", message.acceptorClusterId());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 1: {
                boolean written = writer.writeMessage("acceptorNode", (NetworkMessage)message.acceptorNode());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 2: {
                boolean written = writer.writeBitSet("featureSet", message.featureSet());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 3: {
                boolean written = writer.writeString("productName", message.productName());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }
}

