/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.network.message;

import java.util.Map;
import org.apache.ignite.internal.network.NetworkMessage;
import org.apache.ignite.internal.network.NetworkMessagesFactory;
import org.apache.ignite.internal.network.NetworkMessagesTypeInfos;
import org.apache.ignite.internal.network.message.ScaleCubeMessage;
import org.apache.ignite.internal.network.message.ScaleCubeMessageBuilder;
import org.apache.ignite.internal.network.serialization.MessageCollectionItemType;
import org.apache.ignite.internal.network.serialization.MessageDeserializer;
import org.apache.ignite.internal.network.serialization.MessageMappingException;
import org.apache.ignite.internal.network.serialization.MessageReader;

class ScaleCubeMessageDeserializer
implements MessageDeserializer<ScaleCubeMessage> {
    private final ScaleCubeMessageBuilder msg;

    ScaleCubeMessageDeserializer(NetworkMessagesFactory messageFactory) {
        this.msg = messageFactory.scaleCubeMessage();
    }

    public Class<ScaleCubeMessage> klass() {
        return ScaleCubeMessage.class;
    }

    public ScaleCubeMessage getMessage() {
        return this.msg.buildDeserialized();
    }

    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        reader.setMessageTypeInfo(NetworkMessagesTypeInfos.scaleCubeMessage());
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                Object tmp = reader.readByteArray("dataByteArray");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.dataByteArray((byte[])tmp);
                }
                reader.incrementState();
            }
            case 1: {
                Object tmp = reader.readMap("headers", MessageCollectionItemType.STRING, MessageCollectionItemType.STRING, false);
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.headers((Map<String, String>)tmp);
                }
                reader.incrementState();
            }
            case 2: {
                Object tmp = reader.readMessage("message");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.message((NetworkMessage)tmp);
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(ScaleCubeMessage.class);
    }
}

