/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.network.serialization;

import org.jetbrains.annotations.Nullable;

public enum MessageCollectionItemType {
    BYTE(0),
    SHORT(1),
    INT(2),
    LONG(3),
    FLOAT(4),
    DOUBLE(5),
    CHAR(6),
    BOOLEAN(7),
    BYTE_ARR(8),
    SHORT_ARR(9),
    INT_ARR(10),
    LONG_ARR(11),
    FLOAT_ARR(12),
    DOUBLE_ARR(13),
    CHAR_ARR(14),
    BOOLEAN_ARR(15),
    STRING(16),
    BIT_SET(17),
    BYTE_BUFFER(18),
    UUID(19),
    IGNITE_UUID(20),
    MSG(21),
    HYBRID_TIMESTAMP(22);

    private final byte code;
    private static final MessageCollectionItemType[] VALS;

    private MessageCollectionItemType(int code) {
        this.code = (byte)code;
    }

    public byte code() {
        return this.code;
    }

    @Nullable
    public static MessageCollectionItemType fromOrdinal(int ord) {
        return ord >= 0 && ord < VALS.length ? VALS[ord] : null;
    }

    public static MessageCollectionItemType fromCode(int code) {
        switch (code) {
            case 0: {
                return BYTE;
            }
            case 1: {
                return SHORT;
            }
            case 2: {
                return INT;
            }
            case 3: {
                return LONG;
            }
            case 4: {
                return FLOAT;
            }
            case 5: {
                return DOUBLE;
            }
            case 6: {
                return CHAR;
            }
            case 7: {
                return BOOLEAN;
            }
            case 8: {
                return BYTE_ARR;
            }
            case 9: {
                return SHORT_ARR;
            }
            case 10: {
                return INT_ARR;
            }
            case 11: {
                return LONG_ARR;
            }
            case 12: {
                return FLOAT_ARR;
            }
            case 13: {
                return DOUBLE_ARR;
            }
            case 14: {
                return CHAR_ARR;
            }
            case 15: {
                return BOOLEAN_ARR;
            }
            case 16: {
                return STRING;
            }
            case 17: {
                return BIT_SET;
            }
            case 18: {
                return BYTE_BUFFER;
            }
            case 19: {
                return UUID;
            }
            case 20: {
                return IGNITE_UUID;
            }
            case 21: {
                return MSG;
            }
        }
        throw new IllegalArgumentException("Unsupported code: " + code);
    }

    static {
        VALS = MessageCollectionItemType.values();
    }
}

