/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.util.generators.standard;

import java.util.stream.Stream;
import org.apache.ignite.ml.math.primitives.vector.Vector;
import org.apache.ignite.ml.structures.LabeledVector;
import org.apache.ignite.ml.util.generators.DataStreamGenerator;
import org.apache.ignite.ml.util.generators.primitives.scalar.UniformRandomProducer;

public class TwoSeparableClassesDataStream
implements DataStreamGenerator {
    private final double margin;
    private final double variance;
    private long seed;

    public TwoSeparableClassesDataStream(double margin, double variance) {
        this(margin, variance, System.currentTimeMillis());
    }

    public TwoSeparableClassesDataStream(double margin, double variance, long seed) {
        this.margin = margin;
        this.variance = variance;
        this.seed = seed;
    }

    @Override
    public Stream<LabeledVector<Double>> labeled() {
        this.seed *= 2L;
        double minCordVal = -this.variance - Math.abs(this.margin);
        double maxCordVal = this.variance + Math.abs(this.margin);
        return new UniformRandomProducer(minCordVal, maxCordVal, this.seed).vectorize(2).asDataStream().labeled(this::classify).map(v -> new LabeledVector(this.applyMargin((Vector)v.features()), v.label())).filter(v -> this.between(v.features().get(0), -this.variance, this.variance)).filter(v -> this.between(v.features().get(1), -this.variance, this.variance));
    }

    private boolean between(double x, double min, double max) {
        return x >= min && x <= max;
    }

    private double classify(Vector v) {
        return v.get(0) - v.get(1) > 0.0 ? -1.0 : 1.0;
    }

    private Vector applyMargin(Vector v) {
        Vector cp = v.copy();
        cp.set(0, cp.get(0) + Math.signum(v.get(0) - v.get(1)) * this.margin);
        cp.set(1, cp.get(1) - Math.signum(v.get(0) - v.get(1)) * this.margin);
        return cp;
    }
}

