/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.selection.scoring.metric.classification;

import java.util.Comparator;
import java.util.Iterator;
import java.util.PriorityQueue;
import org.apache.commons.math3.util.Pair;
import org.apache.ignite.ml.selection.scoring.LabelPair;
import org.apache.ignite.ml.selection.scoring.metric.Metric;
import org.apache.ignite.ml.selection.scoring.metric.exceptions.UnknownClassLabelException;

public class ROCAUC
implements Metric<Double> {
    private double positiveClsLb = 1.0;
    private double negativeClsLb;

    @Override
    public double score(Iterator<LabelPair<Double>> iter) {
        PriorityQueue<Pair<Double, Double>> queue = new PriorityQueue<Pair<Double, Double>>(Comparator.comparingDouble(Pair::getKey));
        long pos = 0L;
        long neg = 0L;
        while (iter.hasNext()) {
            LabelPair<Double> e = iter.next();
            Double prediction = e.getPrediction();
            Double truth = e.getTruth();
            queue.add((Pair<Double, Double>)new Pair((Object)prediction, (Object)truth));
            if (truth == this.positiveClsLb) {
                ++pos;
                continue;
            }
            if (truth == this.negativeClsLb) {
                ++neg;
                continue;
            }
            throw new UnknownClassLabelException(truth, this.positiveClsLb, this.negativeClsLb);
        }
        return ROCAUC.calculateROCAUC(queue, pos, neg, this.positiveClsLb);
    }

    public static double calculateROCAUC(PriorityQueue<Pair<Double, Double>> queue, long pos, long neg, double positiveClsLb) {
        double[] lb = new double[queue.size()];
        double[] prediction = new double[queue.size()];
        int cnt = 0;
        while (!queue.isEmpty()) {
            Pair<Double, Double> elem = queue.poll();
            lb[cnt] = (Double)elem.getValue();
            prediction[cnt] = (Double)elem.getKey();
            ++cnt;
        }
        double[] rank = new double[lb.length];
        for (int i = 0; i < prediction.length; ++i) {
            int j;
            if (i == prediction.length - 1 || prediction[i] != prediction[i + 1]) {
                rank[i] = i + 1;
                continue;
            }
            for (j = i + 1; j < prediction.length && prediction[j] == prediction[i]; ++j) {
            }
            double r = (double)(i + 1 + j) / 2.0;
            for (int k = i; k < j; ++k) {
                rank[k] = r;
            }
            i = j - 1;
        }
        double auc = 0.0;
        for (int i = 0; i < lb.length; ++i) {
            if (lb[i] != positiveClsLb) continue;
            auc += rank[i];
        }
        if (pos == 0L) {
            return Double.NaN;
        }
        if (neg == 0L) {
            return Double.NaN;
        }
        auc = (auc - (double)(pos * (pos + 1L)) / 2.0) / (double)(pos * neg);
        return auc;
    }

    public double positiveClsLb() {
        return this.positiveClsLb;
    }

    public ROCAUC withPositiveClsLb(double positiveClsLb) {
        if (Double.isFinite(positiveClsLb)) {
            this.positiveClsLb = positiveClsLb;
        }
        return this;
    }

    public double negativeClsLb() {
        return this.negativeClsLb;
    }

    public ROCAUC withNegativeClsLb(double negativeClsLb) {
        if (Double.isFinite(negativeClsLb)) {
            this.negativeClsLb = negativeClsLb;
        }
        return this;
    }

    @Override
    public String name() {
        return "ROC AUC";
    }
}

