/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.selection.scoring.metric.classification;

import java.util.Iterator;
import org.apache.ignite.ml.selection.scoring.LabelPair;
import org.apache.ignite.ml.selection.scoring.metric.classification.ClassMetric;

public class Fmeasure<L>
extends ClassMetric<L> {
    public Fmeasure(L clsLb) {
        super(clsLb);
    }

    @Override
    public double score(Iterator<LabelPair<L>> it) {
        if (this.clsLb != null) {
            long tp = 0L;
            long fn = 0L;
            long fp = 0L;
            while (it.hasNext()) {
                LabelPair<L> e = it.next();
                L prediction = e.getPrediction();
                L truth = e.getTruth();
                if (this.clsLb.equals(truth)) {
                    if (prediction.equals(truth)) {
                        ++tp;
                    } else {
                        ++fn;
                    }
                }
                if (!this.clsLb.equals(prediction) || prediction.equals(truth)) continue;
                ++fp;
            }
            long denominatorRecall = tp + fn;
            long denominatorPrecision = tp + fp;
            double recall = denominatorRecall == 0L ? 1.0 : (double)tp / (double)denominatorRecall;
            double precision = denominatorPrecision == 0L ? 1.0 : (double)tp / (double)denominatorPrecision;
            return 2.0 * (recall * precision) / (recall + precision);
        }
        return Double.NaN;
    }

    @Override
    public String name() {
        return "F-measure for class with label " + this.clsLb;
    }
}

