/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.preprocessing.imputing;

import java.util.Collections;
import java.util.List;
import org.apache.ignite.ml.environment.deploy.DeployableObject;
import org.apache.ignite.ml.math.primitives.vector.Vector;
import org.apache.ignite.ml.preprocessing.Preprocessor;
import org.apache.ignite.ml.structures.LabeledVector;

public final class ImputerPreprocessor<K, V>
implements Preprocessor<K, V>,
DeployableObject {
    private static final long serialVersionUID = 6887800576392623469L;
    private final Vector imputingValues;
    private final Preprocessor<K, V> basePreprocessor;

    public ImputerPreprocessor(Vector imputingValues, Preprocessor<K, V> basePreprocessor) {
        this.imputingValues = imputingValues;
        this.basePreprocessor = basePreprocessor;
    }

    @Override
    public LabeledVector apply(K k, V v) {
        LabeledVector res = (LabeledVector)this.basePreprocessor.apply(k, v);
        assert (res.size() == this.imputingValues.size());
        for (int i = 0; i < res.size(); ++i) {
            if (!Double.valueOf(res.get(i)).equals(Double.NaN)) continue;
            res.set(i, this.imputingValues.get(i));
        }
        return res;
    }

    @Override
    public List<Object> getDependencies() {
        return Collections.singletonList(this.basePreprocessor);
    }
}

