/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.multiclass;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import org.apache.ignite.ml.Exportable;
import org.apache.ignite.ml.Exporter;
import org.apache.ignite.ml.IgniteModel;
import org.apache.ignite.ml.math.primitives.vector.Vector;

public final class MultiClassModel<M extends IgniteModel<Vector, Double>>
implements IgniteModel<Vector, Double>,
Exportable<MultiClassModel>,
Serializable {
    private static final long serialVersionUID = -114986533359917L;
    private Map<Double, M> models = new HashMap<Double, M>();

    public void add(double clsLb, M mdl) {
        this.models.put(clsLb, mdl);
    }

    public Optional<M> getModel(Double clsLb) {
        return Optional.ofNullable(this.models.get(clsLb));
    }

    @Override
    public Double predict(Vector input) {
        TreeMap maxMargins = new TreeMap();
        this.models.forEach((k, v) -> maxMargins.put(v.predict(input), k));
        return (Double)maxMargins.lastEntry().getValue();
    }

    @Override
    public <P> void saveModel(Exporter<MultiClassModel, P> exporter, P path) {
        exporter.save(this, path);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MultiClassModel mdl = (MultiClassModel)o;
        return Objects.equals(this.models, mdl.models);
    }

    public int hashCode() {
        return Objects.hash(this.models);
    }

    public String toString() {
        StringBuilder wholeStr = new StringBuilder();
        this.models.forEach((clsLb, mdl) -> wholeStr.append("The class with label ").append(clsLb).append(" has classifier: ").append(mdl.toString()).append(System.lineSeparator()));
        return wholeStr.toString();
    }

    @Override
    public String toString(boolean pretty) {
        return this.toString();
    }
}

