/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.math.stat;

import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.ml.math.primitives.matrix.Matrix;
import org.apache.ignite.ml.math.primitives.vector.Vector;
import org.apache.ignite.ml.math.stat.Distribution;

public class MultivariateGaussianDistribution
implements Distribution {
    private Vector mean;
    private Matrix invCovariance;
    private double normalizer;
    private Matrix covariance;

    public MultivariateGaussianDistribution(Vector mean, Matrix covariance) {
        A.ensure((covariance.columnSize() == covariance.rowSize() ? 1 : 0) != 0, (String)"Covariance matrix should be square");
        A.ensure((mean.size() == covariance.rowSize() ? 1 : 0) != 0, (String)"Covariance matrix should be built from same space as mean vector");
        this.mean = mean;
        this.covariance = covariance;
        this.invCovariance = covariance.inverse();
        double determinant = covariance.determinant();
        A.ensure((determinant > 0.0 ? 1 : 0) != 0, (String)"Covariance matrix should be positife definite");
        this.normalizer = Math.pow(Math.PI * 2, (double)this.invCovariance.rowSize() / 2.0) * Math.sqrt(determinant);
    }

    @Override
    public double prob(Vector x) {
        Vector delta = x.minus(this.mean);
        Matrix ePower = delta.toMatrix(true).times(this.invCovariance).times(delta.toMatrix(false)).times(-0.5);
        assert (ePower.columnSize() == 1 && ePower.rowSize() == 1);
        return Math.pow(Math.E, ePower.get(0, 0)) / this.normalizer;
    }

    @Override
    public int dimension() {
        return this.mean.size();
    }

    public Vector mean() {
        return this.mean.copy();
    }

    public Matrix covariance() {
        return this.covariance;
    }
}

