/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.math.isolve.lsqr;

import com.github.fommil.netlib.BLAS;
import java.util.Arrays;
import org.apache.ignite.ml.math.isolve.lsqr.LSQRResult;

public abstract class AbstractLSQR {
    private static final double EPSILON;
    private static final long EXPONENT_OFFSET = 1023L;
    private static final double eps;
    private static BLAS blas;

    public LSQRResult solve(double damp, double atol, double btol, double conlim, double iterLim, boolean calcVar, double[] x0) {
        double rnorm;
        double alfa;
        double beta;
        double[] x;
        Integer n = this.getColumns();
        if (n == null) {
            return null;
        }
        if (iterLim < 0.0) {
            iterLim = 2 * n;
        }
        double[] var = new double[n.intValue()];
        int itn = 0;
        int istop = 0;
        double ctol = 0.0;
        if (conlim > 0.0) {
            ctol = 1.0 / conlim;
        }
        double anorm = 0.0;
        double acond = 0.0;
        double dampsq = Math.pow(damp, 2.0);
        double ddnorm = 0.0;
        double res2 = 0.0;
        double xnorm = 0.0;
        double xxnorm = 0.0;
        double z = 0.0;
        double cs2 = -1.0;
        double sn2 = 0.0;
        double bnorm = this.bnorm();
        if (x0 == null) {
            x = new double[n.intValue()];
            beta = bnorm;
        } else {
            x = x0;
            beta = this.beta(x, -1.0, 1.0);
        }
        double[] v = new double[n.intValue()];
        if (beta > 0.0) {
            v = this.iter(beta, v);
            alfa = blas.dnrm2(v.length, v, 1);
        } else {
            System.arraycopy(x, 0, v, 0, v.length);
            alfa = 0.0;
        }
        if (alfa > 0.0) {
            blas.dscal(v.length, 1.0 / alfa, v, 1);
        }
        double[] w = Arrays.copyOf(v, v.length);
        double rhobar = alfa;
        double phibar = beta;
        double r1norm = rnorm = beta;
        double r2norm = rnorm;
        double arnorm = alfa * beta;
        double[] dk = new double[w.length];
        if (arnorm == 0.0) {
            return new LSQRResult(x, itn, istop, r1norm, r2norm, anorm, acond, arnorm, xnorm, var);
        }
        while ((double)itn < iterLim) {
            ++itn;
            beta = this.beta(v, 1.0, -alfa);
            if (beta > 0.0) {
                anorm = Math.sqrt(Math.pow(anorm, 2.0) + Math.pow(alfa, 2.0) + Math.pow(beta, 2.0) + Math.pow(damp, 2.0));
                blas.dscal(v.length, -beta, v, 1);
                this.iter(beta, v);
                alfa = blas.dnrm2(v.length, v, 1);
                if (alfa > 0.0) {
                    blas.dscal(v.length, 1.0 / alfa, v, 1);
                }
            }
            double rhobar1 = Math.sqrt(Math.pow(rhobar, 2.0) + Math.pow(damp, 2.0));
            double cs1 = rhobar / rhobar1;
            double sn1 = damp / rhobar1;
            double psi = sn1 * phibar;
            phibar = cs1 * phibar;
            double[] symOrtho = AbstractLSQR.symOrtho(rhobar1, beta);
            double cs = symOrtho[0];
            double sn = symOrtho[1];
            double rho = symOrtho[2];
            double theta = sn * alfa;
            rhobar = -cs * alfa;
            double phi = cs * phibar;
            phibar = sn * phibar;
            double tau = sn * phi;
            double t1 = phi / rho;
            double t2 = -theta / rho;
            blas.dcopy(w.length, w, 1, dk, 1);
            blas.dscal(dk.length, 1.0 / rho, dk, 1);
            blas.daxpy(w.length, t1, w, 1, x, 1);
            blas.dscal(w.length, t2, w, 1);
            blas.daxpy(w.length, 1.0, v, 1, w, 1);
            ddnorm += Math.pow(blas.dnrm2(dk.length, dk, 1), 2.0);
            if (calcVar) {
                blas.daxpy(var.length, 1.0, AbstractLSQR.pow2(dk), 1, var, 1);
            }
            double delta = sn2 * rho;
            double gambar = -cs2 * rho;
            double rhs = phi - delta * z;
            double zbar = rhs / gambar;
            xnorm = Math.sqrt(xxnorm + Math.pow(zbar, 2.0));
            double gamma = Math.sqrt(Math.pow(gambar, 2.0) + Math.pow(theta, 2.0));
            cs2 = gambar / gamma;
            sn2 = theta / gamma;
            z = rhs / gamma;
            acond = anorm * Math.sqrt(ddnorm);
            double res1 = Math.pow(phibar, 2.0);
            rnorm = Math.sqrt(res1 + (res2 += Math.pow(psi, 2.0)));
            arnorm = alfa * Math.abs(tau);
            double r1sq = Math.pow(rnorm, 2.0) - dampsq * (xxnorm += Math.pow(z, 2.0));
            r1norm = Math.sqrt(Math.abs(r1sq));
            if (r1sq < 0.0) {
                r1norm = -r1norm;
            }
            r2norm = rnorm;
            double test1 = rnorm / bnorm;
            double test2 = arnorm / (anorm * rnorm + eps);
            double test3 = 1.0 / (acond + eps);
            t1 = test1 / (1.0 + anorm * xnorm / bnorm);
            double rtol = btol + atol * anorm * xnorm / bnorm;
            if ((double)itn >= iterLim) {
                istop = 7;
            }
            if (1.0 + test3 <= 1.0) {
                istop = 6;
            }
            if (1.0 + test2 <= 1.0) {
                istop = 5;
            }
            if (1.0 + t1 <= 1.0) {
                istop = 4;
            }
            if (test3 <= ctol) {
                istop = 3;
            }
            if (test2 <= atol) {
                istop = 2;
            }
            if (test1 <= rtol) {
                istop = 1;
            }
            if (istop == 0) continue;
            break;
        }
        return new LSQRResult(x, itn, istop, r1norm, r2norm, anorm, acond, arnorm, xnorm, var);
    }

    protected abstract double bnorm();

    protected abstract double beta(double[] var1, double var2, double var4);

    protected abstract double[] iter(double var1, double[] var3);

    protected abstract Integer getColumns();

    private static double[] symOrtho(double a, double b) {
        double r;
        double c;
        double s;
        if (b == 0.0) {
            return new double[]{Math.signum(a), 0.0, Math.abs(a)};
        }
        if (a == 0.0) {
            return new double[]{0.0, Math.signum(b), Math.abs(b)};
        }
        if (Math.abs(b) > Math.abs(a)) {
            double tau = a / b;
            s = Math.signum(b) / Math.sqrt(1.0 + tau * tau);
            c = s * tau;
            r = b / s;
        } else {
            double tau = b / a;
            c = Math.signum(a) / Math.sqrt(1.0 + tau * tau);
            s = c * tau;
            r = a / c;
        }
        return new double[]{c, s, r};
    }

    private static double[] pow2(double[] a) {
        double[] res = new double[a.length];
        for (int i = 0; i < res.length; ++i) {
            res[i] = Math.pow(a[i], 2.0);
        }
        return res;
    }

    static {
        eps = EPSILON = Double.longBitsToDouble(4368491638549381120L);
        blas = BLAS.getInstance();
    }
}

