/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.inference.storage.model;

import java.util.LinkedList;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.function.Supplier;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.ml.inference.storage.model.Directory;
import org.apache.ignite.ml.inference.storage.model.File;
import org.apache.ignite.ml.inference.storage.model.FileOrDirectory;
import org.apache.ignite.ml.inference.storage.model.FileStat;
import org.apache.ignite.ml.inference.storage.model.ModelStorage;
import org.apache.ignite.ml.inference.storage.model.ModelStorageProvider;

public class DefaultModelStorage
implements ModelStorage {
    private final ModelStorageProvider storageProvider;

    public DefaultModelStorage(ModelStorageProvider storageProvider) {
        this.storageProvider = storageProvider;
    }

    @Override
    public void putFile(String path, byte[] data, boolean onlyIfNotExist) {
        String parentPath = this.getParent(path);
        Lock pathLock = this.storageProvider.lock(path);
        Lock parentPathLock = this.storageProvider.lock(parentPath);
        DefaultModelStorage.synchronize(() -> {
            if (this.exists(path) && onlyIfNotExist) {
                throw new IllegalArgumentException("File already exists [path=" + path + "]");
            }
            FileOrDirectory parent = this.storageProvider.get(parentPath);
            if (parent == null) {
                throw new IllegalArgumentException("Cannot create file because directory doesn't exist [path=" + path + "]");
            }
            if (!parent.isDirectory()) {
                throw new IllegalArgumentException("Cannot create file because parent is not a directory [path=" + path + "]");
            }
            Directory dir = (Directory)parent;
            if (!dir.getFiles().contains(path)) {
                dir.getFiles().add(path);
                this.storageProvider.put(parentPath, dir.updateModifictaionTs());
            }
            this.storageProvider.put(path, new File(data));
        }, pathLock, parentPathLock);
    }

    @Override
    public byte[] getFile(String path) {
        FileOrDirectory fileOrDir = this.storageProvider.get(path);
        Lock pathLock = this.storageProvider.lock(path);
        return DefaultModelStorage.synchronize(() -> {
            if (fileOrDir == null) {
                throw new IllegalArgumentException("File doesn't exist [path=" + path + "]");
            }
            if (!fileOrDir.isFile()) {
                throw new IllegalArgumentException("File is not a regular file [path=" + path + "]");
            }
            return ((File)fileOrDir).getData();
        }, pathLock);
    }

    @Override
    public void mkdir(String path, boolean onlyIfNotExist) {
        String parentPath = this.getParent(path);
        Lock pathLock = this.storageProvider.lock(path);
        Lock parentPathLock = this.storageProvider.lock(parentPath);
        DefaultModelStorage.synchronize(() -> {
            if (this.isDirectory(path)) {
                if (onlyIfNotExist) {
                    throw new IllegalArgumentException("Directory already exists [path=" + path + "]");
                }
                return;
            }
            if (this.isFile(path)) {
                throw new IllegalArgumentException("File with specified path already exists [path=" + path + "]");
            }
            FileOrDirectory parent = this.storageProvider.get(parentPath);
            if (parent == null) {
                throw new IllegalArgumentException("Cannot create directory because parent directory does not exist [path=" + path + "]");
            }
            if (!parent.isDirectory()) {
                throw new IllegalArgumentException("Cannot create directory because parent is not a directory [path=" + path + "]");
            }
            Directory dir = (Directory)parent;
            dir.getFiles().add(path);
            this.storageProvider.put(parentPath, parent.updateModifictaionTs());
            this.storageProvider.put(path, new Directory());
        }, pathLock, parentPathLock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mkdirs(String path) {
        LinkedList<IgniteBiTuple> pathsToBeCreated = new LinkedList<IgniteBiTuple>();
        IgniteBiTuple parentWithLock = null;
        try {
            while (path != null) {
                Lock lock = this.storageProvider.lock(path);
                lock.lock();
                pathsToBeCreated.push(new IgniteBiTuple((Object)path, (Object)lock));
                if (this.exists(path)) {
                    if (this.isDirectory(path)) {
                        parentWithLock = (IgniteBiTuple)pathsToBeCreated.pop();
                        break;
                    }
                    throw new IllegalArgumentException("Cannot create directory because parent is not a directory [path=" + path + "]");
                }
                path = this.getParent(path);
            }
            while (!pathsToBeCreated.isEmpty()) {
                IgniteBiTuple pathWithLock = (IgniteBiTuple)pathsToBeCreated.pop();
                this.storageProvider.put((String)pathWithLock.get1(), new Directory());
                if (parentWithLock != null) {
                    Directory parentDir = (Directory)this.storageProvider.get((String)parentWithLock.get1());
                    parentDir.getFiles().add((String)pathWithLock.get1());
                    this.storageProvider.put((String)parentWithLock.get1(), parentDir.updateModifictaionTs());
                    ((Lock)parentWithLock.get2()).unlock();
                }
                parentWithLock = pathWithLock;
            }
            if (parentWithLock != null) {
                ((Lock)parentWithLock.get2()).unlock();
            }
        }
        finally {
            for (IgniteBiTuple pathWithLock : pathsToBeCreated) {
                ((Lock)pathWithLock.get2()).unlock();
            }
        }
    }

    @Override
    public Set<String> listFiles(String path) {
        Lock pathLock = this.storageProvider.lock(path);
        return DefaultModelStorage.synchronize(() -> {
            FileOrDirectory dir = this.storageProvider.get(path);
            if (dir == null) {
                throw new IllegalArgumentException("Directory doesn't exist [path=" + path + "]");
            }
            if (!dir.isDirectory()) {
                throw new IllegalArgumentException("Specified path is not associated with directory [path=" + path + "]");
            }
            return ((Directory)dir).getFiles();
        }, pathLock);
    }

    @Override
    public void remove(String path) {
        String parentPath = this.getParent(path);
        Lock pathLock = this.storageProvider.lock(path);
        Lock parentLock = this.storageProvider.lock(parentPath);
        DefaultModelStorage.synchronize(() -> {
            Directory dir;
            FileOrDirectory file = this.storageProvider.get(path);
            if (file.isDirectory() && !(dir = (Directory)file).getFiles().isEmpty()) {
                throw new IllegalArgumentException("Cannot delete non-empty directory [path=" + path + "]");
            }
            this.storageProvider.remove(path);
            Directory parent = (Directory)this.storageProvider.get(parentPath);
            if (parent != null) {
                parent.getFiles().remove(path);
                this.storageProvider.put(parentPath, parent);
            }
        }, pathLock, parentLock);
    }

    @Override
    public boolean exists(String path) {
        return this.storageProvider.get(path) != null;
    }

    @Override
    public boolean isDirectory(String path) {
        FileOrDirectory file = this.storageProvider.get(path);
        return file != null && file.isDirectory();
    }

    @Override
    public boolean isFile(String path) {
        FileOrDirectory file = this.storageProvider.get(path);
        return file != null && file.isFile();
    }

    @Override
    public FileStat getFileStat(String path) {
        FileOrDirectory file = this.storageProvider.get(path);
        if (file == null) {
            throw new IllegalArgumentException("File not found [path=" + path + "]");
        }
        int size = 0;
        if (file.isFile()) {
            size = ((File)file).getData().length;
        }
        return new FileStat(file.isDirectory(), file.getModificationTs(), size);
    }

    @Override
    public <T> T lockPaths(Supplier<T> supplier, String ... paths) {
        Lock[] locks = new Lock[paths.length];
        for (int i = 0; i < paths.length; ++i) {
            locks[i] = this.storageProvider.lock(paths[i]);
        }
        return DefaultModelStorage.synchronize(supplier, locks);
    }

    private String getParent(String path) {
        String[] splittedPath = path.split("/");
        int cnt = 0;
        for (int i = 0; i < splittedPath.length; ++i) {
            if (splittedPath[i].isEmpty()) continue;
            ++cnt;
        }
        if (cnt == 0) {
            return null;
        }
        StringBuilder parentPath = new StringBuilder("/");
        for (int i = 0; i < splittedPath.length; ++i) {
            if (splittedPath[i].isEmpty() || --cnt <= 0) continue;
            parentPath.append(splittedPath[i]).append("/");
        }
        if (parentPath.length() > 1) {
            parentPath.delete(parentPath.length() - 1, parentPath.length());
        }
        return parentPath.toString();
    }

    static void synchronize(Runnable task, Lock ... locks) {
        DefaultModelStorage.synchronize(() -> {
            task.run();
            return null;
        }, locks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static <T> T synchronize(Supplier<T> task, Lock ... locks) {
        T res;
        int i;
        Throwable ex = null;
        try {
            for (i = 0; i < locks.length; ++i) {
                locks[i].lock();
            }
            res = task.get();
        }
        finally {
            --i;
            while (i >= 0) {
                try {
                    locks[i].unlock();
                }
                catch (Error | RuntimeException e) {
                    ex = e;
                }
                --i;
            }
        }
        if (ex != null) {
            if (ex instanceof RuntimeException) {
                throw (RuntimeException)ex;
            }
            if (ex instanceof Error) {
                throw (Error)ex;
            }
            throw new IllegalStateException("Unexpected type of throwable");
        }
        return res;
    }
}

