/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.dataset.impl.local;

import java.io.Serializable;
import java.util.List;
import org.apache.ignite.ml.dataset.Dataset;
import org.apache.ignite.ml.environment.LearningEnvironment;
import org.apache.ignite.ml.math.functions.IgniteBiFunction;
import org.apache.ignite.ml.math.functions.IgniteBinaryOperator;
import org.apache.ignite.ml.math.functions.IgniteTriFunction;

public class LocalDataset<C extends Serializable, D extends AutoCloseable>
implements Dataset<C, D> {
    private final List<LearningEnvironment> envs;
    private final List<C> ctx;
    private final List<D> data;

    LocalDataset(List<LearningEnvironment> envs, List<C> ctx, List<D> data) {
        this.envs = envs;
        this.ctx = ctx;
        this.data = data;
    }

    @Override
    public <R> R computeWithCtx(IgniteTriFunction<C, D, LearningEnvironment, R> map, IgniteBinaryOperator<R> reduce, R identity) {
        R res = identity;
        for (int part = 0; part < this.ctx.size(); ++part) {
            AutoCloseable partData = (AutoCloseable)this.data.get(part);
            LearningEnvironment env = this.envs.get(part);
            if (partData == null) continue;
            res = reduce.apply(res, map.apply((LearningEnvironment)this.ctx.get(part), (D)partData, env));
        }
        return res;
    }

    @Override
    public <R> R compute(IgniteBiFunction<D, LearningEnvironment, R> map, IgniteBinaryOperator<R> reduce, R identity) {
        R res = identity;
        for (int part = 0; part < this.data.size(); ++part) {
            AutoCloseable partData = (AutoCloseable)this.data.get(part);
            LearningEnvironment env = this.envs.get(part);
            if (partData == null) continue;
            res = reduce.apply(res, map.apply(partData, env));
        }
        return res;
    }

    @Override
    public void close() {
    }

    public List<C> getCtx() {
        return this.ctx;
    }

    public List<D> getData() {
        return this.data;
    }
}

