/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.util.plugin;

import java.io.Serializable;
import java.util.UUID;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.processors.platform.client.CustomQueryProcessor;
import org.apache.ignite.internal.processors.platform.client.ThinClientCustomQueryRegistry;
import org.apache.ignite.ml.inference.storage.model.ModelStorageFactory;
import org.apache.ignite.ml.inference.storage.model.thinclient.ModelStorateThinClientProcessor;
import org.apache.ignite.ml.util.plugin.MLPlugin;
import org.apache.ignite.ml.util.plugin.MLPluginConfiguration;
import org.apache.ignite.plugin.CachePluginContext;
import org.apache.ignite.plugin.CachePluginProvider;
import org.apache.ignite.plugin.ExtensionRegistry;
import org.apache.ignite.plugin.IgnitePlugin;
import org.apache.ignite.plugin.PluginConfiguration;
import org.apache.ignite.plugin.PluginContext;
import org.apache.ignite.plugin.PluginProvider;
import org.apache.ignite.plugin.PluginValidationException;
import org.jetbrains.annotations.Nullable;

public class MLPluginProvider
implements PluginProvider<MLPluginConfiguration> {
    private static final String ML_INFERENCE_PLUGIN_NAME = "ml-inference-plugin";
    private static final String ML_INFERENCE_PLUGIN_VERSION = "1.0.0";
    private static final int MODEL_STORAGE_DEFAULT_BACKUPS = 1;
    private static final int MODEL_DESCRIPTOR_STORAGE_DEFAULT_BACKUPS = 1;
    private MLPluginConfiguration cfg;
    private Ignite ignite;
    private IgniteLogger log;

    public String name() {
        return ML_INFERENCE_PLUGIN_NAME;
    }

    public String version() {
        return ML_INFERENCE_PLUGIN_VERSION;
    }

    public String copyright() {
        return "Copyright 2019 GridGain Systems, Inc. and Contributors.";
    }

    public <T extends IgnitePlugin> T plugin() {
        return (T)new MLPlugin();
    }

    public void initExtensions(PluginContext ctx, ExtensionRegistry registry) {
        IgniteConfiguration igniteCfg = ctx.igniteConfiguration();
        this.ignite = ctx.grid();
        this.log = ctx.log(this.getClass());
        if (igniteCfg.getPluginConfigurations() != null) {
            for (PluginConfiguration pluginCfg : igniteCfg.getPluginConfigurations()) {
                if (!(pluginCfg instanceof MLPluginConfiguration)) continue;
                this.cfg = (MLPluginConfiguration)pluginCfg;
                break;
            }
        }
    }

    @Nullable
    public <T> T createComponent(PluginContext ctx, Class<T> cls) {
        return null;
    }

    public CachePluginProvider createCacheProvider(CachePluginContext ctx) {
        return null;
    }

    public void start(PluginContext ctx) {
    }

    public void stop(boolean cancel) {
    }

    public void onIgniteStart() {
        if (this.ignite == null || this.log == null) {
            throw new RuntimeException("Plugin provider has not been initialized");
        }
        if (this.cfg != null) {
            if (this.cfg.isWithMdlStorage()) {
                this.startModelStorage(this.cfg);
            }
            if (this.cfg.isWithMdlDescStorage()) {
                this.startModelDescriptorStorage(this.cfg);
            }
        }
    }

    public void onIgniteStop(boolean cancel) {
    }

    @Nullable
    public Serializable provideDiscoveryData(UUID nodeId) {
        return null;
    }

    public void receiveDiscoveryData(UUID nodeId, Serializable data) {
    }

    public void validateNewNode(ClusterNode node) throws PluginValidationException {
    }

    private void startModelStorage(MLPluginConfiguration cfg) {
        CacheConfiguration storageCfg = new CacheConfiguration();
        storageCfg.setName("MODEL_STORAGE");
        storageCfg.setCacheMode(CacheMode.PARTITIONED);
        storageCfg.setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL);
        if (cfg.getMdlStorageBackups() == null) {
            storageCfg.setBackups(1);
        } else {
            storageCfg.setBackups(cfg.getMdlStorageBackups().intValue());
        }
        this.ignite.getOrCreateCache(storageCfg);
        boolean procWasRegistered = ThinClientCustomQueryRegistry.registerIfAbsent((CustomQueryProcessor)new ModelStorateThinClientProcessor(new ModelStorageFactory().getModelStorage(this.ignite)));
        if (!procWasRegistered) {
            this.log.warning("Processor ML_MODEL_STORAGE is already registered");
        }
        if (this.log.isInfoEnabled()) {
            this.log.info("ML model storage is ready");
        }
    }

    private void startModelDescriptorStorage(MLPluginConfiguration cfg) {
        CacheConfiguration storageCfg = new CacheConfiguration();
        storageCfg.setName("MODEL_DESCRIPTOR_STORAGE");
        storageCfg.setCacheMode(CacheMode.PARTITIONED);
        storageCfg.setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL);
        if (cfg.getMdlDescStorageBackups() == null) {
            storageCfg.setBackups(1);
        }
        this.ignite.getOrCreateCache(storageCfg);
        if (this.log.isInfoEnabled()) {
            this.log.info("ML model descriptor storage is ready");
        }
    }
}

