/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.tree;

import org.apache.ignite.ml.math.primitives.vector.Vector;
import org.apache.ignite.ml.tree.DecisionTree;
import org.apache.ignite.ml.tree.DecisionTreeNode;

public final class DecisionTreeConditionalNode
implements DecisionTreeNode {
    private static final long serialVersionUID = 981630737007982172L;
    private final int col;
    private final double threshold;
    private DecisionTreeNode thenNode;
    private DecisionTreeNode elseNode;
    private DecisionTreeNode missingNode;

    public DecisionTreeConditionalNode(int col, double threshold, DecisionTreeNode thenNode, DecisionTreeNode elseNode, DecisionTreeNode missingNode) {
        this.col = col;
        this.threshold = threshold;
        this.thenNode = thenNode;
        this.elseNode = elseNode;
        this.missingNode = missingNode;
    }

    @Override
    public Double predict(Vector features) {
        double val = features.get(this.col);
        if (Double.isNaN(val)) {
            if (this.missingNode == null) {
                throw new IllegalArgumentException("Feature must not be null or missing node should be specified");
            }
            return (Double)this.missingNode.predict(features);
        }
        return val > this.threshold ? (Double)this.thenNode.predict(features) : (Double)this.elseNode.predict(features);
    }

    public int getCol() {
        return this.col;
    }

    public double getThreshold() {
        return this.threshold;
    }

    public DecisionTreeNode getThenNode() {
        return this.thenNode;
    }

    public void setThenNode(DecisionTreeNode thenNode) {
        this.thenNode = thenNode;
    }

    public DecisionTreeNode getElseNode() {
        return this.elseNode;
    }

    public void setElseNode(DecisionTreeNode elseNode) {
        this.elseNode = elseNode;
    }

    public DecisionTreeNode getMissingNode() {
        return this.missingNode;
    }

    public void setMissingNode(DecisionTreeNode missingNode) {
        this.missingNode = missingNode;
    }

    public String toString() {
        return this.toString(false);
    }

    @Override
    public String toString(boolean pretty) {
        return DecisionTree.printTree(this, pretty);
    }
}

