/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.selection.scoring.metric.classification;

import java.util.Iterator;
import org.apache.ignite.ml.selection.scoring.LabelPair;
import org.apache.ignite.ml.selection.scoring.metric.classification.ClassMetric;

public class Precision<L>
extends ClassMetric<L> {
    public Precision(L clsLb) {
        super(clsLb);
    }

    @Override
    public double score(Iterator<LabelPair<L>> it) {
        if (this.clsLb != null) {
            long tp = 0L;
            long fp = 0L;
            while (it.hasNext()) {
                LabelPair<L> e = it.next();
                L prediction = e.getPrediction();
                L truth = e.getTruth();
                if (!this.clsLb.equals(prediction)) continue;
                if (prediction.equals(truth)) {
                    ++tp;
                    continue;
                }
                ++fp;
            }
            long denominator = tp + fp;
            if (denominator == 0L) {
                return 1.0;
            }
            return (double)tp / (double)denominator;
        }
        return Double.NaN;
    }

    @Override
    public String name() {
        return "precision for class with label " + this.clsLb;
    }
}

