/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.math.primitives.vector.impl;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.ignite.ml.math.primitives.vector.NamedVector;
import org.apache.ignite.ml.math.primitives.vector.Vector;
import org.apache.ignite.ml.math.primitives.vector.impl.DelegatingVector;

public class DelegatingNamedVector
extends DelegatingVector
implements NamedVector {
    private static final long serialVersionUID = -3425468245964928754L;
    private Map<String, Integer> map;

    public DelegatingNamedVector() {
        this.map = Collections.emptyMap();
    }

    public DelegatingNamedVector(Vector vector, Map<String, Integer> map) {
        super(vector);
        this.map = Objects.requireNonNull(map);
    }

    @Override
    public double get(String idx) {
        int intIdx = Objects.requireNonNull(this.map.get(idx), "Index not found [name='" + idx + "']");
        return this.get(intIdx);
    }

    @Override
    public NamedVector set(String idx, double val) {
        int intIdx = Objects.requireNonNull(this.map.get(idx), "Index not found [name='" + idx + "']");
        this.set(intIdx, val);
        return this;
    }

    @Override
    public Set<String> getKeys() {
        return this.map.keySet();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.map);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.map = (Map)in.readObject();
    }
}

