/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.composition.predictionsaggregator;

import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.ml.composition.predictionsaggregator.PredictionsAggregator;

public final class WeightedPredictionsAggregator
implements PredictionsAggregator {
    private final double[] weights;
    private final double bias;

    public WeightedPredictionsAggregator(double[] weights) {
        this.weights = weights;
        this.bias = 0.0;
    }

    public WeightedPredictionsAggregator(double[] weights, double bias) {
        this.weights = weights;
        this.bias = bias;
    }

    @Override
    public Double apply(double[] answers) {
        A.ensure((answers.length == this.weights.length ? 1 : 0) != 0, (String)"Composition vector must have same size as weights vector");
        double res = this.bias;
        for (int i = 0; i < answers.length; ++i) {
            res += this.weights[i] * answers[i];
        }
        return res;
    }

    public String toString() {
        return this.toString(false);
    }

    @Override
    public String toString(boolean pretty) {
        String clsName = this.getClass().getSimpleName();
        if (!pretty) {
            return clsName;
        }
        StringBuilder builder = new StringBuilder(clsName).append(" [");
        for (int i = 0; i < this.weights.length; ++i) {
            String SIGN = this.weights[i] > 0.0 ? " + " : " - ";
            builder.append(i > 0 || this.weights[i] < 0.0 ? SIGN : "").append(String.format("%.4f", Math.abs(this.weights[i]))).append("*x").append(i);
        }
        return builder.append(this.bias > 0.0 ? " + " : " - ").append(String.format("%.4f", this.bias)).append("]").toString();
    }

    public double[] getWeights() {
        return this.weights;
    }

    public double getBias() {
        return this.bias;
    }
}

