/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.clustering.gmm;

import java.io.Serializable;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.ml.clustering.gmm.GmmModel;
import org.apache.ignite.ml.clustering.gmm.GmmPartitionData;
import org.apache.ignite.ml.dataset.Dataset;
import org.apache.ignite.ml.dataset.primitive.context.EmptyContext;
import org.apache.ignite.ml.math.primitives.vector.Vector;

public class NewComponentStatisticsAggregator
implements Serializable {
    private static final long serialVersionUID = 6748270328889375005L;
    private long totalRowCount;
    private long rowCountForNewCluster;
    private Vector sumOfAnomalies;

    public NewComponentStatisticsAggregator(long totalRowCount, long rowCountForNewCluster, Vector sumOfAnomalies) {
        this.totalRowCount = totalRowCount;
        this.rowCountForNewCluster = rowCountForNewCluster;
        this.sumOfAnomalies = sumOfAnomalies;
    }

    public NewComponentStatisticsAggregator() {
    }

    public Vector mean() {
        return this.sumOfAnomalies.divide(this.rowCountForNewCluster);
    }

    public long rowCountForNewCluster() {
        return this.rowCountForNewCluster;
    }

    public long totalRowCount() {
        return this.totalRowCount;
    }

    static NewComponentStatisticsAggregator computeNewMean(Dataset<EmptyContext, GmmPartitionData> dataset, double maxXsProb, double maxProbDivergence, GmmModel currentModel) {
        return (NewComponentStatisticsAggregator)dataset.compute(data -> NewComponentStatisticsAggregator.computeNewMeanMap(data, maxXsProb, maxProbDivergence, currentModel), NewComponentStatisticsAggregator::computeNewMeanReduce);
    }

    static NewComponentStatisticsAggregator computeNewMeanMap(GmmPartitionData data, double maxXsProb, double maxProbDivergence, GmmModel currentModel) {
        NewComponentStatisticsAggregator adder = new NewComponentStatisticsAggregator();
        for (int i = 0; i < data.size(); ++i) {
            Vector x;
            adder.add(x, currentModel.prob(x = data.getX(i)) < maxXsProb / maxProbDivergence);
        }
        return adder;
    }

    void add(Vector x, boolean isAnomaly) {
        if (isAnomaly) {
            this.sumOfAnomalies = this.sumOfAnomalies == null ? x.copy() : this.sumOfAnomalies.plus(x);
            ++this.rowCountForNewCluster;
        }
        ++this.totalRowCount;
    }

    static NewComponentStatisticsAggregator computeNewMeanReduce(NewComponentStatisticsAggregator left, NewComponentStatisticsAggregator right) {
        A.ensure((left != null || right != null ? 1 : 0) != 0, (String)"left != null || right != null");
        if (left == null) {
            return right;
        }
        if (right == null) {
            return left;
        }
        return left.plus(right);
    }

    NewComponentStatisticsAggregator plus(NewComponentStatisticsAggregator other) {
        return new NewComponentStatisticsAggregator(this.totalRowCount + other.totalRowCount, this.rowCountForNewCluster + other.rowCountForNewCluster, this.sumOfAnomalies.plus(other.sumOfAnomalies));
    }
}

