/*
 * Copyright 2019 GridGain Systems, Inc. and Contributors.
 *
 * Licensed under the GridGain Community Edition License (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.gridgain.com/products/software/community-edition/gridgain-community-edition-license
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.ignite.ml.selection.scoring.cursor;

import org.apache.ignite.ml.selection.scoring.LabelPair;

/**
 * Closeable iterable that supplies pairs of truth and predictions (abstraction that hides a difference between querying
 * data from Ignite cache and from local Map).
 *
 * @param <L> Type of a label (truth or prediction).
 */
public interface LabelPairCursor<L> extends Iterable<LabelPair<L>>, AutoCloseable {
}
