/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.util.generators.primitives.scalar;

import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.ml.util.generators.primitives.scalar.RandomProducerWithGenerator;

public class UniformRandomProducer
extends RandomProducerWithGenerator {
    private final double from;
    private final double to;

    public UniformRandomProducer(double from, double to) {
        this(from, to, System.currentTimeMillis());
    }

    public UniformRandomProducer(double from, double to, long seed) {
        super(seed);
        A.ensure((to >= from ? 1 : 0) != 0, (String)"from >= to");
        this.from = from;
        this.to = to;
    }

    @Override
    public Double get() {
        double result = this.generator().nextDouble() * (this.to - this.from) + this.from;
        if (result > this.to) {
            result = this.to;
        }
        return result;
    }
}

