/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.tree.randomforest.data.impurity;

import java.io.Serializable;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import org.apache.ignite.ml.tree.randomforest.data.NodeSplit;

public abstract class ImpurityHistogram
implements Serializable {
    private static final long serialVersionUID = -8982240673834216798L;
    protected final Set<Integer> bucketIds = new TreeSet<Integer>();
    protected final int featureId;

    public ImpurityHistogram(int featureId) {
        this.featureId = featureId;
    }

    protected Optional<NodeSplit> checkAndReturnSplitValue(int bestBucketId, double bestSplitVal, double bestGain, double impurity) {
        if (this.isLastBucket(bestBucketId)) {
            return Optional.empty();
        }
        return Optional.of(new NodeSplit(this.featureId, bestSplitVal, bestGain, impurity));
    }

    private boolean isLastBucket(int bestBucketId) {
        int minBucketId = Integer.MAX_VALUE;
        int maxBucketId = Integer.MIN_VALUE;
        for (Integer bucketId : this.bucketIds) {
            minBucketId = Math.min(minBucketId, bucketId);
            maxBucketId = Math.max(maxBucketId, bucketId);
        }
        return bestBucketId == maxBucketId;
    }
}

