/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.selection.scoring.evaluator;

import java.util.Map;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.lang.IgniteBiPredicate;
import org.apache.ignite.ml.IgniteModel;
import org.apache.ignite.ml.math.primitives.vector.Vector;
import org.apache.ignite.ml.preprocessing.Preprocessor;
import org.apache.ignite.ml.selection.scoring.cursor.CacheBasedLabelPairCursor;
import org.apache.ignite.ml.selection.scoring.cursor.LocalLabelPairCursor;
import org.apache.ignite.ml.selection.scoring.metric.AbstractMetrics;
import org.apache.ignite.ml.selection.scoring.metric.Metric;
import org.apache.ignite.ml.selection.scoring.metric.MetricValues;
import org.apache.ignite.ml.selection.scoring.metric.classification.BinaryClassificationMetricValues;
import org.apache.ignite.ml.selection.scoring.metric.classification.BinaryClassificationMetrics;
import org.apache.ignite.ml.selection.scoring.metric.regression.RegressionMetricValues;
import org.apache.ignite.ml.selection.scoring.metric.regression.RegressionMetrics;

public class Evaluator {
    public static <L, K, V> double evaluate(IgniteCache<K, V> dataCache, IgniteModel<Vector, L> mdl, Preprocessor<K, V> preprocessor, Metric<L> metric) {
        return Evaluator.calculateMetric(dataCache, null, mdl, preprocessor, metric);
    }

    public static <L, K, V> double evaluate(Map<K, V> dataCache, IgniteModel<Vector, L> mdl, Preprocessor<K, V> preprocessor, Metric<L> metric) {
        return Evaluator.calculateMetric(dataCache, null, mdl, preprocessor, metric);
    }

    public static <L, K, V> double evaluate(IgniteCache<K, V> dataCache, IgniteBiPredicate<K, V> filter, IgniteModel<Vector, L> mdl, Preprocessor<K, V> preprocessor, Metric<L> metric) {
        return Evaluator.calculateMetric(dataCache, filter, mdl, preprocessor, metric);
    }

    public static <L, K, V> double evaluate(Map<K, V> dataCache, IgniteBiPredicate<K, V> filter, IgniteModel<Vector, L> mdl, Preprocessor<K, V> preprocessor, Metric<L> metric) {
        return Evaluator.calculateMetric(dataCache, filter, mdl, preprocessor, metric);
    }

    public static <K, V> BinaryClassificationMetricValues evaluate(IgniteCache<K, V> dataCache, IgniteModel<Vector, Double> mdl, Preprocessor<K, V> preprocessor) {
        return Evaluator.calcMetricValues(dataCache, null, mdl, preprocessor);
    }

    public static <K, V> BinaryClassificationMetricValues evaluate(Map<K, V> dataCache, IgniteModel<Vector, Double> mdl, Preprocessor<K, V> preprocessor) {
        return Evaluator.calcMetricValues(dataCache, null, mdl, preprocessor);
    }

    public static <K, V> BinaryClassificationMetricValues evaluate(IgniteCache<K, V> dataCache, IgniteBiPredicate<K, V> filter, IgniteModel<Vector, Double> mdl, Preprocessor<K, V> preprocessor) {
        return Evaluator.calcMetricValues(dataCache, filter, mdl, preprocessor);
    }

    public static <K, V> BinaryClassificationMetricValues evaluate(Map<K, V> dataCache, IgniteBiPredicate<K, V> filter, IgniteModel<Vector, Double> mdl, Preprocessor<K, V> preprocessor) {
        return Evaluator.calcMetricValues(dataCache, filter, mdl, preprocessor);
    }

    public static <K, V> RegressionMetricValues evaluateRegression(IgniteCache<K, V> dataCache, IgniteBiPredicate<K, V> filter, IgniteModel<Vector, Double> mdl, Preprocessor<K, V> preprocessor) {
        return Evaluator.calcRegressionMetricValues(dataCache, filter, mdl, preprocessor);
    }

    private static <K, V> RegressionMetricValues calcRegressionMetricValues(IgniteCache<K, V> dataCache, IgniteBiPredicate<K, V> filter, IgniteModel<Vector, Double> mdl, Preprocessor<K, V> preprocessor) {
        return Evaluator.calcMetricValues(dataCache, filter, mdl, preprocessor, new RegressionMetrics());
    }

    private static <K, V> BinaryClassificationMetricValues calcMetricValues(IgniteCache<K, V> dataCache, IgniteBiPredicate<K, V> filter, IgniteModel<Vector, Double> mdl, Preprocessor<K, V> preprocessor) {
        MetricValues metricValues;
        BinaryClassificationMetrics binaryMetrics = new BinaryClassificationMetrics();
        try (CacheBasedLabelPairCursor<Double, K, V> cursor = new CacheBasedLabelPairCursor<Double, K, V>(dataCache, filter, preprocessor, mdl);){
            metricValues = binaryMetrics.scoreAll(cursor.iterator());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return metricValues;
    }

    private static <K, V> BinaryClassificationMetricValues calcMetricValues(Map<K, V> dataCache, IgniteBiPredicate<K, V> filter, IgniteModel<Vector, Double> mdl, Preprocessor<K, V> preprocessor) {
        MetricValues metricValues;
        BinaryClassificationMetrics binaryMetrics = new BinaryClassificationMetrics();
        try (LocalLabelPairCursor cursor = new LocalLabelPairCursor(dataCache, filter, preprocessor, mdl);){
            metricValues = binaryMetrics.scoreAll(cursor.iterator());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return metricValues;
    }

    private static <L, K, V> double calculateMetric(IgniteCache<K, V> dataCache, IgniteBiPredicate<K, V> filter, IgniteModel<Vector, L> mdl, Preprocessor<K, V> preprocessor, Metric<L> metric) {
        double metricRes;
        try (CacheBasedLabelPairCursor<L, K, V> cursor = new CacheBasedLabelPairCursor<L, K, V>(dataCache, filter, preprocessor, mdl);){
            metricRes = metric.score(cursor.iterator());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return metricRes;
    }

    private static <L, K, V> double calculateMetric(Map<K, V> dataCache, IgniteBiPredicate<K, V> filter, IgniteModel<Vector, L> mdl, Preprocessor<K, V> preprocessor, Metric<L> metric) {
        double metricRes;
        try (LocalLabelPairCursor cursor = new LocalLabelPairCursor(dataCache, filter, preprocessor, mdl);){
            metricRes = metric.score(cursor.iterator());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return metricRes;
    }

    private static <K, V, M extends MetricValues> M calcMetricValues(IgniteCache<K, V> dataCache, IgniteBiPredicate<K, V> filter, IgniteModel<Vector, Double> mdl, Preprocessor<K, V> preprocessor, AbstractMetrics<M> metrics) {
        M metricValues;
        try (CacheBasedLabelPairCursor<Double, K, V> cursor = new CacheBasedLabelPairCursor<Double, K, V>(dataCache, filter, preprocessor, mdl);){
            metricValues = metrics.scoreAll(cursor.iterator());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return metricValues;
    }
}

