/*
 * Copyright 2019 GridGain Systems, Inc. and Contributors.
 *
 * Licensed under the GridGain Community Edition License (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.gridgain.com/products/software/community-edition/gridgain-community-edition-license
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.ignite.ml.knn.ann;

import java.util.TreeMap;

/**
 * The special class for fuzzy labels presenting the probability distribution
 * over the class labels.
 */
public class ProbableLabel {
    /** Key is label, value is probability to be this class */
    TreeMap<Double, Double> clsLbls;

    /**
     * The key is class label,
     * the value is the probability to be an item of this class.
     *
     * @param clsLbls Class labels.
     */
    public ProbableLabel(TreeMap<Double, Double> clsLbls) {
        this.clsLbls = clsLbls;
    }
}
