/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.tree.boosting;

import org.apache.ignite.ml.composition.boosting.GDBBinaryClassifierTrainer;
import org.apache.ignite.ml.composition.boosting.GDBLearningStrategy;
import org.apache.ignite.ml.environment.LearningEnvironmentBuilder;
import org.apache.ignite.ml.tree.DecisionTreeRegressionTrainer;
import org.apache.ignite.ml.tree.boosting.GDBOnTreesLearningStrategy;
import org.jetbrains.annotations.NotNull;

public class GDBBinaryClassifierOnTreesTrainer
extends GDBBinaryClassifierTrainer {
    private int maxDepth;
    private double minImpurityDecrease;
    private boolean usingIdx = true;

    public GDBBinaryClassifierOnTreesTrainer(double gradStepSize, Integer cntOfIterations, int maxDepth, double minImpurityDecrease) {
        super(gradStepSize, cntOfIterations);
        this.maxDepth = maxDepth;
        this.minImpurityDecrease = minImpurityDecrease;
    }

    @NotNull
    protected DecisionTreeRegressionTrainer buildBaseModelTrainer() {
        return new DecisionTreeRegressionTrainer(this.maxDepth, this.minImpurityDecrease).withUsingIdx(this.usingIdx);
    }

    @Override
    protected GDBLearningStrategy getLearningStrategy() {
        return new GDBOnTreesLearningStrategy(this.usingIdx);
    }

    @Override
    public GDBBinaryClassifierOnTreesTrainer withEnvironmentBuilder(LearningEnvironmentBuilder envBuilder) {
        return super.withEnvironmentBuilder(envBuilder);
    }

    public GDBBinaryClassifierOnTreesTrainer withUsingIdx(boolean usingIdx) {
        this.usingIdx = usingIdx;
        return this;
    }

    public int getMaxDepth() {
        return this.maxDepth;
    }

    public GDBBinaryClassifierOnTreesTrainer setMaxDepth(int maxDepth) {
        this.maxDepth = maxDepth;
        return this;
    }

    public double getMinImpurityDecrease() {
        return this.minImpurityDecrease;
    }

    public GDBBinaryClassifierOnTreesTrainer setMinImpurityDecrease(double minImpurityDecrease) {
        this.minImpurityDecrease = minImpurityDecrease;
        return this;
    }

    public boolean isUsingIdx() {
        return this.usingIdx;
    }
}

