/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.selection.scoring.metric.classification;

import org.apache.ignite.ml.selection.scoring.metric.MetricValues;

public class BinaryClassificationMetricValues
implements MetricValues {
    private double tp;
    private double tn;
    private double fp;
    private double fn;
    private double recall;
    private double specificity;
    private double precision;
    private double npv;
    private double fallOut;
    private double fdr;
    private double missRate;
    private double accuracy;
    private double balancedAccuracy;
    private double f1Score;
    private double rocauc;

    public BinaryClassificationMetricValues(long tp, long tn, long fp, long fn, double rocauc) {
        this.tp = tp;
        this.tn = tn;
        this.fp = fp;
        this.fn = fn;
        this.rocauc = rocauc;
        long p = tp + fn;
        long n = tn + fp;
        long positivePredictions = tp + fp;
        long negativePredictions = tn + fn;
        this.recall = p == 0L ? 1.0 : (double)tp / (double)p;
        this.precision = positivePredictions == 0L ? 1.0 : (double)tp / (double)positivePredictions;
        this.specificity = n == 0L ? 1.0 : (double)tn / (double)n;
        this.npv = negativePredictions == 0L ? 1.0 : (double)tn / (double)negativePredictions;
        this.fallOut = n == 0L ? 1.0 : (double)fp / (double)n;
        this.fdr = positivePredictions == 0L ? 1.0 : (double)fp / (double)positivePredictions;
        this.missRate = p == 0L ? 1.0 : (double)fn / (double)p;
        this.f1Score = 2.0 * (this.recall * this.precision) / (this.recall + this.precision);
        this.accuracy = p + n == 0L ? 1.0 : (double)(tp + tn) / (double)(p + n);
        this.balancedAccuracy = p == 0L && n == 0L ? 1.0 : ((double)tp / (double)p + (double)tn / (double)n) / 2.0;
    }

    public double tp() {
        return this.tp;
    }

    public double tn() {
        return this.tn;
    }

    public double fp() {
        return this.fp;
    }

    public double fn() {
        return this.fn;
    }

    public double recall() {
        return this.recall;
    }

    public double specificity() {
        return this.specificity;
    }

    public double precision() {
        return this.precision;
    }

    public double npv() {
        return this.npv;
    }

    public double fallOut() {
        return this.fallOut;
    }

    public double fdr() {
        return this.fdr;
    }

    public double missRate() {
        return this.missRate;
    }

    public double accuracy() {
        return this.accuracy;
    }

    public double balancedAccuracy() {
        return this.balancedAccuracy;
    }

    public double f1Score() {
        return this.f1Score;
    }

    public double rocauc() {
        return this.rocauc;
    }
}

