/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.math.primitives.vector.storage;

import it.unimi.dsi.fastutil.ints.IntArraySet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.ignite.ml.math.StorageConstants;
import org.apache.ignite.ml.math.primitives.vector.VectorStorage;

public class SparseVectorStorage
implements VectorStorage,
StorageConstants {
    private int size;
    private Map<Integer, Serializable> sto;

    public SparseVectorStorage() {
    }

    public SparseVectorStorage(Map<Integer, ? extends Serializable> map, boolean cp) {
        assert (!map.isEmpty());
        this.size = map.size();
        this.sto = new HashMap<Integer, Serializable>(map);
    }

    public SparseVectorStorage(int size) {
        assert (size > 0);
        this.size = size;
        this.sto = new HashMap<Integer, Serializable>();
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public double get(int i) {
        Serializable obj = this.sto.get(i);
        if (obj == null) {
            return 0.0;
        }
        return ((Number)obj).doubleValue();
    }

    @Override
    public <T extends Serializable> T getRaw(int i) {
        return (T)this.sto.get(i);
    }

    @Override
    public void set(int i, double v) {
        if (v != 0.0) {
            this.sto.put(i, Double.valueOf(v));
        } else if (this.sto.containsKey(i)) {
            this.sto.remove(i);
        }
    }

    @Override
    public void setRaw(int i, Serializable v) {
        if (v == null) {
            this.sto.remove(i);
        } else {
            this.sto.put(i, v);
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.size);
        out.writeObject(this.sto);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.size = in.readInt();
        this.sto = (Map)in.readObject();
    }

    @Override
    public boolean isDense() {
        return false;
    }

    @Override
    public boolean isDistributed() {
        return false;
    }

    @Override
    public boolean isArrayBased() {
        return false;
    }

    @Override
    public boolean isNumeric() {
        return this.sto.values().stream().allMatch(v -> v instanceof Number) || this.sto.isEmpty();
    }

    @Override
    public double[] data() {
        if (!this.isNumeric()) {
            throw new ClassCastException("Vector has not only numeric values.");
        }
        double[] data = new double[this.size];
        this.sto.forEach((idx, val) -> {
            data[idx.intValue()] = ((Number)val).doubleValue();
        });
        return data;
    }

    @Override
    public Serializable[] rawData() {
        Serializable[] res = new Serializable[this.size];
        this.sto.forEach((i, v) -> {
            res[i.intValue()] = v;
        });
        return res;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SparseVectorStorage that = (SparseVectorStorage)o;
        return this.size == that.size && (this.sto != null ? this.sto.equals(that.sto) : that.sto == null);
    }

    public int hashCode() {
        int res = this.size;
        res = 31 * res + (this.sto != null ? this.sto.hashCode() : 0);
        return res;
    }

    public IntSet indexes() {
        return new IntArraySet(this.sto.keySet());
    }
}

