/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.knn;

import java.util.Collections;
import java.util.List;
import java.util.PriorityQueue;
import org.apache.ignite.ml.IgniteModel;
import org.apache.ignite.ml.dataset.Dataset;
import org.apache.ignite.ml.dataset.primitive.context.EmptyContext;
import org.apache.ignite.ml.knn.utils.PointWithDistanceUtil;
import org.apache.ignite.ml.knn.utils.indices.SpatialIndex;
import org.apache.ignite.ml.math.distances.DistanceMeasure;
import org.apache.ignite.ml.math.primitives.vector.Vector;
import org.apache.ignite.ml.structures.LabeledVector;

public abstract class KNNModel<L>
implements IgniteModel<Vector, L>,
SpatialIndex<L> {
    private final Dataset<EmptyContext, SpatialIndex<L>> dataset;
    protected final DistanceMeasure distanceMeasure;
    protected final int k;
    protected final boolean weighted;

    protected KNNModel(Dataset<EmptyContext, SpatialIndex<L>> dataset, DistanceMeasure distanceMeasure, int k, boolean weighted) {
        this.dataset = dataset;
        this.distanceMeasure = distanceMeasure;
        this.k = k;
        this.weighted = weighted;
    }

    @Override
    public List<LabeledVector<L>> findKClosest(int k, Vector pnt) {
        List res = (List)this.dataset.compute(spatialIdx -> spatialIdx.findKClosest(k, pnt), (a, b) -> {
            PriorityQueue heap = new PriorityQueue(Collections.reverseOrder());
            PointWithDistanceUtil.tryToAddIntoHeap(heap, k, pnt, a, this.distanceMeasure);
            PointWithDistanceUtil.tryToAddIntoHeap(heap, k, pnt, b, this.distanceMeasure);
            return PointWithDistanceUtil.transfomToListOrdered(heap);
        });
        return res == null ? Collections.emptyList() : res;
    }

    @Override
    public void close() {
        try {
            this.dataset.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

