/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.tree.leaf;

import org.apache.ignite.ml.dataset.Dataset;
import org.apache.ignite.ml.dataset.primitive.context.EmptyContext;
import org.apache.ignite.ml.tree.DecisionTreeLeafNode;
import org.apache.ignite.ml.tree.TreeFilter;
import org.apache.ignite.ml.tree.data.DecisionTreeData;
import org.apache.ignite.ml.tree.leaf.DecisionTreeLeafBuilder;

public class MeanDecisionTreeLeafBuilder
implements DecisionTreeLeafBuilder {
    @Override
    public DecisionTreeLeafNode createLeafNode(Dataset<EmptyContext, DecisionTreeData> dataset, TreeFilter pred) {
        double[] aa = (double[])dataset.compute(part -> {
            double mean = 0.0;
            int cnt = 0;
            for (int i = 0; i < part.getFeatures().length; ++i) {
                if (!pred.test(part.getFeatures()[i])) continue;
                mean += part.getLabels()[i];
                ++cnt;
            }
            if (cnt != 0) {
                return new double[]{mean /= (double)cnt, cnt};
            }
            return null;
        }, this::reduce);
        return aa != null ? new DecisionTreeLeafNode(aa[0]) : null;
    }

    private double[] reduce(double[] a, double[] b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        double aMean = a[0];
        double aCnt = a[1];
        double bMean = b[0];
        double bCnt = b[1];
        double mean = (aMean * aCnt + bMean * bCnt) / (aCnt + bCnt);
        return new double[]{mean, aCnt + bCnt};
    }
}

