/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.trainers.transformers;

import java.util.stream.Stream;
import org.apache.commons.math3.distribution.PoissonDistribution;
import org.apache.commons.math3.random.RandomGenerator;
import org.apache.commons.math3.random.Well19937c;
import org.apache.ignite.ml.dataset.UpstreamEntry;
import org.apache.ignite.ml.dataset.UpstreamTransformer;
import org.apache.ignite.ml.dataset.UpstreamTransformerBuilder;

public class BaggingUpstreamTransformer
implements UpstreamTransformer {
    private static final long serialVersionUID = -913152523469994149L;
    private double subsampleRatio;
    private long seed;

    public static <K, V> UpstreamTransformerBuilder builder(double subsampleRatio, int mdlIdx) {
        return env -> new BaggingUpstreamTransformer(env.randomNumbersGenerator().nextLong() + (long)mdlIdx, subsampleRatio);
    }

    public BaggingUpstreamTransformer(long seed, double subsampleRatio) {
        this.subsampleRatio = subsampleRatio;
        this.seed = seed;
    }

    @Override
    public Stream<UpstreamEntry> transform(Stream<UpstreamEntry> upstream) {
        PoissonDistribution poisson = new PoissonDistribution((RandomGenerator)new Well19937c(this.seed), this.subsampleRatio, 1.0E-12, 10000000);
        return ((Stream)upstream.sequential()).flatMap(en -> Stream.generate(() -> en).limit(poisson.sample()));
    }
}

