/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.selection.cv;

import java.io.Serializable;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.lang.IgniteBiPredicate;
import org.apache.ignite.ml.IgniteModel;
import org.apache.ignite.ml.dataset.impl.cache.CacheBasedDatasetBuilder;
import org.apache.ignite.ml.math.primitives.vector.Vector;
import org.apache.ignite.ml.pipeline.PipelineMdl;
import org.apache.ignite.ml.selection.cv.AbstractCrossValidation;
import org.apache.ignite.ml.selection.scoring.cursor.CacheBasedLabelPairCursor;

public class CrossValidation<M extends IgniteModel<Vector, L>, L, K, V>
extends AbstractCrossValidation<M, L, K, V> {
    private Ignite ignite;
    private IgniteCache<K, V> upstreamCache;

    @Override
    public double[] scoreByFolds() {
        double[] locScores = this.isRunningOnPipeline ? this.scorePipelineOnIgnite() : this.scoreOnIgnite();
        return locScores;
    }

    private double[] scorePipelineOnIgnite() {
        return this.scorePipeline(predicate -> new CacheBasedDatasetBuilder<K, V>(this.ignite, this.upstreamCache, (IgniteBiPredicate & Serializable)(k, v) -> this.filter.apply(k, v) && predicate.apply(k, v)), (predicate, mdl) -> new CacheBasedLabelPairCursor(this.upstreamCache, (IgniteBiPredicate & Serializable)(k, v) -> this.filter.apply(k, v) && !predicate.apply(k, v), ((PipelineMdl)mdl).getPreprocessor(), mdl));
    }

    private double[] scoreOnIgnite() {
        return this.score(predicate -> new CacheBasedDatasetBuilder<K, V>(this.ignite, this.upstreamCache, (IgniteBiPredicate & Serializable)(k, v) -> this.filter.apply(k, v) && predicate.apply(k, v)), (predicate, mdl) -> new CacheBasedLabelPairCursor(this.upstreamCache, (IgniteBiPredicate & Serializable)(k, v) -> this.filter.apply(k, v) && !predicate.apply(k, v), this.preprocessor, mdl));
    }

    public CrossValidation<M, L, K, V> withIgnite(Ignite ignite) {
        this.ignite = ignite;
        return this;
    }

    public CrossValidation<M, L, K, V> withUpstreamCache(IgniteCache<K, V> upstreamCache) {
        this.upstreamCache = upstreamCache;
        return this;
    }
}

