/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.math.primitives.matrix.storage;

import it.unimi.dsi.fastutil.ints.Int2DoubleOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2DoubleRBTreeMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.Map;
import org.apache.ignite.ml.math.StorageConstants;
import org.apache.ignite.ml.math.functions.IgniteTriFunction;
import org.apache.ignite.ml.math.primitives.matrix.MatrixStorage;

public class SparseMatrixStorage
implements MatrixStorage,
StorageConstants {
    private static final double DEFAULT_VALUE = 0.0;
    private int rows;
    private int cols;
    private int acsMode;
    private int stoMode;
    private Map<Integer, Map<Integer, Double>> sto;

    public SparseMatrixStorage() {
    }

    public SparseMatrixStorage(int rows, int cols, int acsMode, int stoMode) {
        assert (rows > 0);
        assert (cols > 0);
        this.assertAccessMode(acsMode);
        this.assertStorageMode(stoMode);
        this.rows = rows;
        this.cols = cols;
        this.acsMode = acsMode;
        this.stoMode = stoMode;
        this.sto = new HashMap<Integer, Map<Integer, Double>>();
    }

    @Override
    public int storageMode() {
        return this.stoMode;
    }

    @Override
    public int accessMode() {
        return this.acsMode;
    }

    @Override
    public double get(int x, int y) {
        Double val;
        if (this.stoMode == 2001) {
            Double val2;
            Map<Integer, Double> row = this.sto.get(x);
            if (row != null && (val2 = row.get(y)) != null) {
                return val2;
            }
            return 0.0;
        }
        Map<Integer, Double> col = this.sto.get(y);
        if (col != null && (val = col.get(x)) != null) {
            return val;
        }
        return 0.0;
    }

    @Override
    public void set(int x, int y, double v) {
        Map<Integer, Double> col;
        if (v != 0.0) {
            if (this.stoMode == 2001) {
                Map row = this.sto.computeIfAbsent(x, k -> this.acsMode == 1001 ? new Int2DoubleRBTreeMap() : new Int2DoubleOpenHashMap());
                row.put(y, v);
            } else {
                Map col2 = this.sto.computeIfAbsent(y, k -> this.acsMode == 1001 ? new Int2DoubleRBTreeMap() : new Int2DoubleOpenHashMap());
                col2.put(x, v);
            }
        } else if (this.stoMode == 2001) {
            Map<Integer, Double> row;
            if (this.sto.containsKey(x) && (row = this.sto.get(x)).containsKey(y)) {
                row.remove(y);
            }
        } else if (this.sto.containsKey(y) && (col = this.sto.get(y)).containsKey(x)) {
            col.remove(x);
        }
    }

    @Override
    public int columnSize() {
        return this.cols;
    }

    @Override
    public int rowSize() {
        return this.rows;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.rows);
        out.writeInt(this.cols);
        out.writeInt(this.acsMode);
        out.writeInt(this.stoMode);
        out.writeObject(this.sto);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.rows = in.readInt();
        this.cols = in.readInt();
        this.acsMode = in.readInt();
        this.stoMode = in.readInt();
        this.sto = (Map)in.readObject();
    }

    @Override
    public boolean isDense() {
        return false;
    }

    @Override
    public boolean isDistributed() {
        return false;
    }

    @Override
    public boolean isArrayBased() {
        return false;
    }

    @Override
    public double[] data() {
        double[] res = new double[this.rows * this.cols];
        boolean isRowStorage = this.stoMode == 2001;
        this.sto.forEach((fstIdx, map) -> map.forEach((sndIdx, val) -> {
            if (isRowStorage) {
                res[sndIdx.intValue() * this.rows + fstIdx.intValue()] = val;
            } else {
                res[fstIdx.intValue() * this.cols + sndIdx.intValue()] = val;
            }
        }));
        return res;
    }

    public int hashCode() {
        int res = 1;
        res = res * 37 + this.rows;
        res = res * 37 + this.cols;
        res = res * 37 + this.sto.hashCode();
        return res;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SparseMatrixStorage that = (SparseMatrixStorage)o;
        return this.rows == that.rows && this.cols == that.cols && this.acsMode == that.acsMode && this.stoMode == that.stoMode && (this.sto != null ? this.sto.equals(that.sto) : that.sto == null);
    }

    public void compute(int row, int col, IgniteTriFunction<Integer, Integer, Double, Double> f) {
        this.sto.get(row).compute(col, (c, val) -> (Double)f.apply(row, (Integer)c, (Double)val));
    }

    public Int2ObjectArrayMap<IntSet> indexesMap() {
        Int2ObjectArrayMap res = new Int2ObjectArrayMap();
        for (Integer row : this.sto.keySet()) {
            res.put(row.intValue(), (Object)((IntSet)this.sto.get(row).keySet()));
        }
        return res;
    }
}

